/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.inspections;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.client.api.response.Process;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.inspections.InspectionUtility;
import io.camunda.zeebe.process.test.inspections.model.InspectedProcessInstance;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import java.time.Duration;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractProcessEventInspectionsTest {
    private static final String WRONG_TIMER_ID = "wrongtimer";

    @Test
    void testFindFirstProcessInstance() throws InterruptedException {
        DeploymentEvent deploymentEvent = Utilities.deployResource(this.getClient(), "timer-start-event-daily.bpmn");
        Utilities.increaseTime(this.getEngine(), Duration.ofDays(1L));
        Optional firstProcessInstance = InspectionUtility.findProcessEvents().triggeredByTimer("timer").withProcessDefinitionKey(((Process)deploymentEvent.getProcesses().get(0)).getProcessDefinitionKey()).findFirstProcessInstance();
        Assertions.assertThat((Optional)firstProcessInstance).isNotEmpty();
        BpmnAssert.assertThat((InspectedProcessInstance)((InspectedProcessInstance)firstProcessInstance.get())).isCompleted();
    }

    @Test
    void testFindLastProcessInstance() throws InterruptedException {
        DeploymentEvent deploymentEvent = Utilities.deployResource(this.getClient(), "timer-start-event-daily.bpmn");
        Utilities.increaseTime(this.getEngine(), Duration.ofDays(1L));
        Optional lastProcessInstance = InspectionUtility.findProcessEvents().triggeredByTimer("timer").withProcessDefinitionKey(((Process)deploymentEvent.getProcesses().get(0)).getProcessDefinitionKey()).findLastProcessInstance();
        Assertions.assertThat((Optional)lastProcessInstance).isNotEmpty();
        BpmnAssert.assertThat((InspectedProcessInstance)((InspectedProcessInstance)lastProcessInstance.get())).isCompleted();
    }

    @Test
    void testFindFirstProcessInstance_wrongTimer() throws InterruptedException {
        Utilities.deployResource(this.getClient(), "timer-start-event-daily.bpmn");
        Utilities.increaseTime(this.getEngine(), Duration.ofDays(1L));
        Optional processInstance = InspectionUtility.findProcessEvents().triggeredByTimer(WRONG_TIMER_ID).findFirstProcessInstance();
        Assertions.assertThat((Optional)processInstance).isEmpty();
    }

    @Test
    void testFindProcessInstance_highIndex() throws InterruptedException {
        Utilities.deployResource(this.getClient(), "timer-start-event-daily.bpmn");
        Utilities.increaseTime(this.getEngine(), Duration.ofDays(1L));
        Optional processInstance = InspectionUtility.findProcessEvents().findProcessInstance(10);
        Assertions.assertThat((Optional)processInstance).isEmpty();
    }

    public abstract ZeebeClient getClient();

    public abstract ZeebeTestEngine getEngine();
}

