/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.inspections;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.inspections.FormInspectionsUtility;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import io.camunda.zeebe.protocol.record.value.deployment.FormMetadataValue;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractFormInspectionsTest {
    private ZeebeClient client;
    private ZeebeTestEngine engine;

    @Test
    void shouldFindTheLatestVersion() throws InterruptedException, TimeoutException {
        Utilities.deployResource(this.client, "test-form.form");
        Utilities.deployResources(this.client, "test-form-v2.form");
        this.engine.waitForIdleState(Duration.ofSeconds(1L));
        Optional latestForm = FormInspectionsUtility.findLatestFormById((String)"Form_0w7r08e");
        Assertions.assertThat((boolean)latestForm.isPresent()).isTrue();
        FormMetadataValue form = (FormMetadataValue)latestForm.get();
        Assertions.assertThat((String)form.getFormId()).isEqualTo("Form_0w7r08e");
        Assertions.assertThat((int)form.getVersion()).isEqualTo(2);
    }
}

