/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.assertions;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.assertions.IncidentAssert;
import io.camunda.zeebe.process.test.assertions.ProcessInstanceAssert;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public abstract class AbstractProcessInstanceAssertTest {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final Map<String, Object> TYPED_TEST_VARIABLES = new HashMap<String, Object>();

    static {
        TYPED_TEST_VARIABLES.put("stringProperty", "stringValue");
        TYPED_TEST_VARIABLES.put("numberProperty", 123);
        TYPED_TEST_VARIABLES.put("booleanProperty", true);
        TYPED_TEST_VARIABLES.put("complexProperty", Arrays.asList("Element 1", "Element 2"));
        TYPED_TEST_VARIABLES.put("nullProperty", null);
    }

    @Nested
    class RegressionTests {
        private ZeebeClient client;
        private ZeebeTestEngine engine;

        RegressionTests() {
        }

        @Test
        public void testShouldCaptureLatestValueOfVariable() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables1 = Collections.singletonMap("totalLoops", "1");
            Map<String, String> variables2 = Collections.singletonMap("totalLoops", "2");
            Map<String, String> variables3 = Collections.singletonMap("totalLoops", "3");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables1);
            this.client.newSetVariablesCommand(instanceEvent.getProcessInstanceKey()).variables(variables2).send().join();
            this.client.newSetVariablesCommand(instanceEvent.getProcessInstanceKey()).variables(variables3).send().join();
            Utilities.waitForIdleState(this.engine, Duration.ofSeconds(1L));
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasVariableWithValue("totalLoops", (Object)"3");
        }
    }

    @Nested
    class UnhappyPathTests {
        private ZeebeClient client;
        private ZeebeTestEngine engine;

        UnhappyPathTests() {
        }

        @Test
        void testProcessInstanceIsStartedFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent mockInstanceEvent = (ProcessInstanceEvent)Mockito.mock(ProcessInstanceEvent.class);
            Mockito.when((Object)mockInstanceEvent.getProcessInstanceKey()).thenReturn((Object)-1L);
            org.junit.jupiter.api.Assertions.assertThrows(AssertionError.class, () -> ((ProcessInstanceAssert)BpmnAssert.assertThat((ProcessInstanceEvent)mockInstanceEvent)).isStarted(), (String)"Process with key -1 was not started");
        }

        @Test
        void testProcessInstanceIsNotStartedIfProcessInstanceKeyNoMatch() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ProcessInstanceEvent mockInstanceEvent = (ProcessInstanceEvent)Mockito.mock(ProcessInstanceEvent.class);
            Mockito.when((Object)mockInstanceEvent.getProcessInstanceKey()).thenReturn((Object)-1L);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)mockInstanceEvent).isStarted()).isInstanceOf(AssertionError.class)).hasMessage("Process with key -1 was not started");
        }

        @Test
        void testProcessInstanceIsActiveFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", Collections.singletonMap("totalLoops", 1));
            Utilities.completeTask(this.engine, this.client, "servicetask");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isActive()).isInstanceOf(AssertionError.class)).hasMessage("Process with key %s is not active", new Object[]{instanceEvent.getProcessInstanceKey()});
        }

        @Test
        void testProcessInstanceIsCompletedFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", Collections.singletonMap("totalLoops", 1));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isCompleted()).isInstanceOf(AssertionError.class)).hasMessage("Process with key %s was not completed", new Object[]{instanceEvent.getProcessInstanceKey()});
        }

        @Test
        void testProcessInstanceIsNotCompletedFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", Collections.singletonMap("totalLoops", 1));
            Utilities.completeTask(this.engine, this.client, "servicetask");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isNotCompleted()).isInstanceOf(AssertionError.class)).hasMessage("Process with key %s was completed", new Object[]{instanceEvent.getProcessInstanceKey()});
        }

        @Test
        void testProcessInstanceIsTerminatedFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", Collections.singletonMap("totalLoops", 1));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isTerminated()).isInstanceOf(AssertionError.class)).hasMessage("Process with key %s was not terminated", new Object[]{instanceEvent.getProcessInstanceKey()});
        }

        @Test
        void testHasCalledProcessFailNoProcessCalled() throws InterruptedException, TimeoutException {
            Utilities.deployResources(this.client, "call-activity.bpmn", "start-end.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "call-activity");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).extractingLatestCalledProcess().hasCalledProcess()).isInstanceOf(AssertionError.class)).hasMessage("No process was called from this process");
        }

        @Test
        void testHasCalledProcessFailSpecificProcessCalled() throws InterruptedException, TimeoutException {
            Utilities.deployResources(this.client, "call-activity.bpmn", "start-end.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "call-activity");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasCalledProcess("NonCalledProcessID")).isInstanceOf(AssertionError.class)).hasMessage("No process with id `NonCalledProcessID` was called from this process");
        }

        @Test
        void testHasNotCalledProcessFailSpecificProcess() throws InterruptedException, TimeoutException {
            Utilities.deployResources(this.client, "call-activity.bpmn", "start-end.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "call-activity");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasNotCalledProcess("start-end")).isInstanceOf(AssertionError.class)).hasMessage("A process with id `%s` was called from this process", new Object[]{"start-end"});
        }

        @Test
        void testHasNotCalledProcessFailAnyProcess() throws InterruptedException, TimeoutException {
            Utilities.deployResources(this.client, "call-activity.bpmn", "start-end.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "call-activity");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasNotCalledProcess()).isInstanceOf(AssertionError.class)).hasMessage("A process was called from this process, distinct called processes are: [start-end]");
        }

        @Test
        void testHasNotCalledProcessFailMultipleProcesses() throws InterruptedException, TimeoutException {
            Utilities.deployResources(this.client, "multiple-call-activity.bpmn", "alternate-start-end.bpmn", "call-activity.bpmn", "start-end.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-call-activity");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasNotCalledProcess()).isInstanceOf(AssertionError.class)).hasMessage("A process was called from this process, distinct called processes are: [alternate-start-end, call-activity]");
        }

        @Test
        void testExtractingLatestCalledProcessFailAnyProcess() throws InterruptedException, TimeoutException {
            Utilities.deployResources(this.client, "call-activity.bpmn", "start-end.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "call-activity");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).extractingLatestCalledProcess().extractingLatestCalledProcess()).isInstanceOf(AssertionError.class)).hasMessage("No process was called from this process");
        }

        @Test
        void testExtractingLatestCalledProcessFailSpecificProcess() throws InterruptedException, TimeoutException {
            Utilities.deployResources(this.client, "call-activity.bpmn", "start-end.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "call-activity");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).extractingLatestCalledProcess("NonCalledProcessId")).isInstanceOf(AssertionError.class)).hasMessage("No process with id `NonCalledProcessId` was called from this process");
        }

        @Test
        void testProcessInstanceIsNotTerminatedFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", Collections.singletonMap("totalLoops", 1));
            this.client.newCancelInstanceCommand(instanceEvent.getProcessInstanceKey()).send().join();
            Utilities.waitForIdleState(this.engine, Duration.ofSeconds(1L));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isNotTerminated()).isInstanceOf(AssertionError.class)).hasMessage("Process with key %s was terminated", new Object[]{instanceEvent.getProcessInstanceKey()});
        }

        @Test
        void testProcessInstanceHasPassedElementFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", Collections.singletonMap("totalLoops", 1));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasPassedElement("servicetask")).isInstanceOf(AssertionError.class)).hasMessage("Expected element with id %s to be passed 1 times, but was 0", new Object[]{"servicetask"});
        }

        @Test
        void testProcessInstanceHasNotPassedElementFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", Collections.singletonMap("totalLoops", 1));
            Utilities.completeTask(this.engine, this.client, "servicetask");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasNotPassedElement("servicetask")).isInstanceOf(AssertionError.class)).hasMessage("Expected element with id %s to be passed 0 times, but was 1", new Object[]{"servicetask"});
        }

        @Test
        void testProcessInstanceHasPassedElementsInOrderFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            Utilities.completeTask(this.engine, this.client, "servicetask");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasPassedElementsInOrder(new String[]{"endevent", "servicetask", "startevent"})).isInstanceOf(AssertionError.class)).hasMessage("[Ordered elements] " + LINE_SEPARATOR + "expected: [\"endevent\", \"servicetask\", \"startevent\"]" + LINE_SEPARATOR + " but was: [\"startevent\", \"servicetask\", \"endevent\"]");
        }

        @Test
        void testProcessInstanceIsWaitingAtFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "multiple-tasks.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-tasks");
            Utilities.completeTask(this.engine, this.client, "servicetask1");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isWaitingAtElements(new String[]{"servicetask1"})).isInstanceOf(AssertionError.class)).hasMessageContainingAll(new CharSequence[]{"to contain", "servicetask1"});
        }

        @Test
        void testProcessInstanceIsWaitingAtMultipleElementsFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "multiple-tasks.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-tasks");
            Utilities.completeTask(this.engine, this.client, "servicetask1");
            Utilities.completeTask(this.engine, this.client, "servicetask2");
            Utilities.completeTask(this.engine, this.client, "servicetask3");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isWaitingAtElements(new String[]{"servicetask1", "servicetask2", "servicetask3"})).isInstanceOf(AssertionError.class)).hasMessageContainingAll(new CharSequence[]{"to contain:", "servicetask1", "servicetask2", "servicetask3"});
        }

        @Test
        void testProcessInstanceWaitingAtNonExistingElementFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "multiple-tasks.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-tasks");
            String nonExistingTaskId = "non-existing-task";
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isWaitingAtElements(new String[]{"non-existing-task"})).isInstanceOf(AssertionError.class)).hasMessageContainingAll(new CharSequence[]{"to contain", "non-existing-task"});
        }

        @Test
        void testProcessInstanceIsNotWaitingAtFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "multiple-tasks.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-tasks");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isNotWaitingAtElements(new String[]{"servicetask1"})).isInstanceOf(AssertionError.class)).hasMessageContainingAll(new CharSequence[]{"not to contain", "servicetask1"});
        }

        @Test
        void testProcessInstanceIsNotWaitingAtMulitpleElementsFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "multiple-tasks.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-tasks");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isNotWaitingAtElements(new String[]{"servicetask1", "servicetask2", "servicetask3"})).isInstanceOf(AssertionError.class)).hasMessageContainingAll(new CharSequence[]{"not to contain", "servicetask1", "servicetask2", "servicetask3"});
        }

        @Test
        void testProcessInstanceIsWaitingExactlyAtElementsFailure_tooManyElements() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "multiple-tasks.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-tasks");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isWaitingExactlyAtElements(new String[]{"servicetask1"})).isInstanceOf(AssertionError.class)).hasMessageContainingAll(new CharSequence[]{String.format("Process with key %s is waiting at element(s) with id(s)", instanceEvent.getProcessInstanceKey()), "servicetask2", "servicetask3"}).hasMessageNotContaining("servicetask1");
        }

        @Test
        void testProcessInstanceIsWaitingExactlyAtElementsFailure_tooLittleElements() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "multiple-tasks.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-tasks");
            Utilities.completeTask(this.engine, this.client, "servicetask1");
            Utilities.completeTask(this.engine, this.client, "servicetask2");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isWaitingExactlyAtElements(new String[]{"servicetask1", "servicetask2", "servicetask3"})).isInstanceOf(AssertionError.class)).hasMessageContainingAll(new CharSequence[]{String.format("Process with key %s is not waiting at element(s) with id(s)", instanceEvent.getProcessInstanceKey()), "servicetask1", "servicetask2"}).hasMessageNotContaining("servicetask3");
        }

        @Test
        void testProcessInstanceIsWaitingExactlyAtElementsFailure_combination() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "multiple-tasks.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-tasks");
            Utilities.completeTask(this.engine, this.client, "servicetask1");
            Utilities.completeTask(this.engine, this.client, "servicetask2");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isWaitingExactlyAtElements(new String[]{"servicetask1", "servicetask2"})).isInstanceOf(AssertionError.class)).hasMessageContainingAll(new CharSequence[]{String.format("Process with key %s is not waiting at element(s) with id(s)", instanceEvent.getProcessInstanceKey()), "servicetask1", "servicetask2", String.format("Process with key %s is waiting at element(s) with id(s)", instanceEvent.getProcessInstanceKey()), "servicetask3"});
        }

        @Test
        void testProcessInstanceIsWaitingForMessageFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            String correlationKey = "key";
            Map<String, Object> variables = Collections.singletonMap("correlationKey", "key");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "message-event", variables);
            Utilities.sendMessage(this.engine, this.client, "message", "key");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isWaitingForMessages(new String[]{"message"})).isInstanceOf(AssertionError.class)).hasMessageContainingAll(new CharSequence[]{"to contain:", "message"});
        }

        @Test
        void testProcessInstanceIsNotWaitingForMessageFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            String correlationKey = "key";
            Map<String, Object> variables = Collections.singletonMap("correlationKey", "key");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "message-event", variables);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isNotWaitingForMessages(new String[]{"message"})).isInstanceOf(AssertionError.class)).hasMessageContainingAll(new CharSequence[]{"not to contain", "message"});
        }

        @Test
        void testProcessInstanceHasVariableFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            String expectedVariable = "variable";
            String actualVariable = "loopAmount";
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasVariable("variable")).isInstanceOf(AssertionError.class)).hasMessage("Unable to find variable with name `%s`. Available variables are: [%s]", new Object[]{"variable", "loopAmount"});
        }

        @Test
        void testProcessInstanceHasVariableWithValueFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            String variable = "variable";
            String expectedValue = "expectedValue";
            String actualValue = "actualValue";
            Map<String, Object> variables = Collections.singletonMap("variable", "actualValue");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasVariableWithValue("variable", (Object)"expectedValue")).isInstanceOf(AssertionError.class)).hasMessage("The variable '%s' does not have the expected value. The value passed in ('%s') is internally mapped to a JSON String that yields '\"%s\"'. However, the actual value (as JSON String) is '\"%s\"'.", new Object[]{"variable", "expectedValue", "expectedValue", "actualValue"});
        }

        @Test
        void testHasCorrelatedMessageByNameFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            String correlationKey = "key";
            Map<String, Object> variables = Collections.singletonMap("correlationKey", "key");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "message-event", variables);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasCorrelatedMessageByName("message", 1)).isInstanceOf(AssertionError.class)).hasMessage("Expected message with name '%s' to be correlated %d times, but was %d times", new Object[]{"message", 1, 0});
        }

        @Test
        void testHasCorrelatedMessageByCorrelationKeyFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            String correlationKey = "key";
            Map<String, Object> variables = Collections.singletonMap("correlationKey", "key");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "message-event", variables);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasCorrelatedMessageByCorrelationKey("key", 1)).isInstanceOf(AssertionError.class)).hasMessage("Expected message with correlation key '%s' to be correlated %d times, but was %d times", new Object[]{"key", 1, 0});
        }

        @Test
        void testHasAnyIncidentsFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasAnyIncidents()).isInstanceOf(AssertionError.class)).hasMessage("No incidents were raised for this process instance");
        }

        @Test
        void testHasNoIncidentsFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", "invalid value");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            Utilities.completeTask(this.engine, this.client, "servicetask");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasNoIncidents()).isInstanceOf(AssertionError.class)).hasMessage("Incidents were raised for this process instance");
        }

        @Test
        void testExtractLatestIncidentFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).extractingLatestIncident()).isInstanceOf(AssertionError.class)).hasMessage("No incidents were raised for this process instance");
        }
    }

    @Nested
    class HappyPathTests {
        private ZeebeClient client;
        private ZeebeTestEngine engine;

        HappyPathTests() {
        }

        @Test
        void testProcessInstanceIsStarted() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isStarted();
        }

        @Test
        void testHasCalledProcess() throws InterruptedException, TimeoutException {
            Utilities.deployResources(this.client, "multiple-call-activity.bpmn", "alternate-start-end.bpmn", "call-activity.bpmn", "start-end.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-call-activity");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasCalledProcess("alternate-start-end").hasCalledProcess("call-activity").hasNotCalledProcess("start-end").extractingLatestCalledProcess("call-activity").hasCalledProcess("start-end").extractingLatestCalledProcess().hasNotCalledProcess();
        }

        @Test
        void testHasNotCalledProcess() throws InterruptedException, TimeoutException {
            Utilities.deployResources(this.client, "call-activity.bpmn", "start-end.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "call-activity");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasCalledProcess("start-end").hasNotCalledProcess("NonCalledProcessID").hasCalledProcess().extractingLatestCalledProcess().hasNotCalledProcess().hasNotCalledProcess("NonCalledProcessID");
        }

        @Test
        void testExtractingLastCalledSpecificProcess() throws InterruptedException, TimeoutException {
            Utilities.deployResources(this.client, "multiple-call-activity.bpmn", "alternate-start-end.bpmn", "call-activity.bpmn", "start-end.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-call-activity");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).extractingLatestCalledProcess("call-activity").hasCalledProcess("start-end");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).extractingLatestCalledProcess("alternate-start-end").hasNotCalledProcess();
        }

        @Test
        void testExtractingLastCalledProcess() throws InterruptedException, TimeoutException {
            Utilities.deployResources(this.client, "multiple-call-activity.bpmn", "alternate-start-end.bpmn", "call-activity.bpmn", "start-end.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-call-activity");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).extractingLatestCalledProcess().hasNotCalledProcess();
        }

        @Test
        void testProcessInstanceIsActive() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isActive();
        }

        @Test
        void testProcessInstanceIsCompleted() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            Utilities.completeTask(this.engine, this.client, "servicetask");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isCompleted();
        }

        @Test
        void testProcessInstanceIsNotCompleted() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isNotCompleted();
        }

        @Test
        void testProcessInstanceIsTerminated() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            this.client.newCancelInstanceCommand(instanceEvent.getProcessInstanceKey()).send().join();
            Utilities.waitForIdleState(this.engine, Duration.ofSeconds(1L));
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isTerminated();
        }

        @Test
        void testProcessInstanceIsNotTerminated() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isNotTerminated();
        }

        @Test
        void testProcessInstanceHasPassedElement() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            Utilities.completeTask(this.engine, this.client, "servicetask");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasPassedElement("servicetask");
        }

        @Test
        void testProcessInstanceHasNotPassedElement() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasNotPassedElement("servicetask");
        }

        @Test
        void testProcessInstanceHasPassedElementMultipleTimes() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            int totalLoops = 5;
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 5);
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            for (int i = 0; i < 5; ++i) {
                Utilities.completeTask(this.engine, this.client, "servicetask");
            }
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasPassedElement("servicetask", 5);
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasPassedElement("loopSequenceFlow", 4);
        }

        @Test
        void testProcessInstanceHasPassedElementsInOrder() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 2);
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            Utilities.completeTask(this.engine, this.client, "servicetask");
            Utilities.completeTask(this.engine, this.client, "servicetask");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasPassedElementsInOrder(new String[]{"startevent", "servicetask", "Gateway_0fhwf5d", "loopSequenceFlow", "servicetask", "Gateway_0fhwf5d", "endevent"});
        }

        @Test
        void testProcessInstanceIsWaitingAt() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "multiple-tasks.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-tasks");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isWaitingAtElements(new String[]{"servicetask1"});
        }

        @Test
        void testProcessIsWaitingAtMultipleElements() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "multiple-tasks.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-tasks");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isWaitingAtElements(new String[]{"servicetask1", "servicetask2", "servicetask3"});
        }

        @Test
        void testProcessInstanceIsNotWaitingAt() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "multiple-tasks.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-tasks");
            Utilities.completeTask(this.engine, this.client, "servicetask1");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isNotWaitingAtElements(new String[]{"servicetask1"});
        }

        @Test
        void testProcessInstanceIsNotWaitingAtMultipleElements() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "multiple-tasks.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-tasks");
            Utilities.completeTask(this.engine, this.client, "servicetask1");
            Utilities.completeTask(this.engine, this.client, "servicetask2");
            Utilities.completeTask(this.engine, this.client, "servicetask3");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isNotWaitingAtElements(new String[]{"servicetask1", "servicetask2", "servicetask3"});
        }

        @Test
        void testProcessInstanceIsNotWaitingAtNonExistingElement() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "multiple-tasks.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-tasks");
            String nonExistingElementId = "non-existing-task";
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isNotWaitingAtElements(new String[]{"non-existing-task"});
        }

        @Test
        void testProcessInstanceIsWaitingExactlyAtElements() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "multiple-tasks.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "multiple-tasks");
            Utilities.completeTask(this.engine, this.client, "servicetask1");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isWaitingExactlyAtElements(new String[]{"servicetask2", "servicetask3"});
        }

        @Test
        void testProcessInstanceIsWaitingForMessage() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            Map<String, Object> variables = Collections.singletonMap("correlationKey", "key");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "message-event", variables);
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isWaitingForMessages(new String[]{"message"});
        }

        @Test
        void testProcessInstanceIsNotWaitingForMessage() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            String correlationKey = "key";
            Map<String, Object> variables = Collections.singletonMap("correlationKey", "key");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "message-event", variables);
            Utilities.sendMessage(this.engine, this.client, "message", "key");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).isNotWaitingForMessages(new String[]{"message"});
        }

        @Test
        void testProcessInstanceHasVariable() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasVariable("totalLoops");
        }

        @Test
        void testProcessInstanceHasVariableWithValue() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", TYPED_TEST_VARIABLES);
            Assertions.assertThatNoException().isThrownBy(() -> TYPED_TEST_VARIABLES.forEach((key, value) -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasVariableWithValue(key, value)));
        }

        @Test
        void testHasCorrelatedMessageByName() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            String correlationKey = "key";
            Map<String, Object> variables = Collections.singletonMap("correlationKey", "key");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "message-event", variables);
            Utilities.sendMessage(this.engine, this.client, "message", "key");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasCorrelatedMessageByName("message", 1);
        }

        @Test
        void testHasCorrelatedMessageByCorrelationKey() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            String correlationKey = "key";
            Map<String, Object> variables = Collections.singletonMap("correlationKey", "key");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "message-event", variables);
            Utilities.sendMessage(this.engine, this.client, "message", "key");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasCorrelatedMessageByCorrelationKey("key", 1);
        }

        @Test
        void testHasAnyIncidents() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", "invalid value");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            Utilities.completeTask(this.engine, this.client, "servicetask");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasAnyIncidents();
        }

        @Test
        void testHasNoIncidents() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasNoIncidents();
        }

        @Test
        void testExtractLatestIncident() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", "invalid value");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            Utilities.completeTask(this.engine, this.client, "servicetask");
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).extractingLatestIncident();
            Assertions.assertThat((Object)incidentAssert).isNotNull();
            incidentAssert.isUnresolved().hasErrorType(ErrorType.EXTRACT_VALUE_ERROR).wasRaisedInProcessInstance(instanceEvent);
        }
    }
}

