/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.assertions;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.assertions.ProcessAssert;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public abstract class AbstractProcessAssertTest {
    public static final String WRONG_VALUE = "wrong value";

    @Nested
    class UnhappyPathTests {
        private ZeebeClient client;
        private ZeebeTestEngine engine;

        UnhappyPathTests() {
        }

        @Test
        void testHasBPMNProcessIdFailure() throws InterruptedException, TimeoutException {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessAssert processAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByBpmnProcessId("looping-servicetask");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> processAssert.hasBpmnProcessId(AbstractProcessAssertTest.WRONG_VALUE)).isInstanceOf(AssertionError.class)).hasMessage("Expected BPMN process ID to be '%s' but was '%s' instead.", new Object[]{AbstractProcessAssertTest.WRONG_VALUE, "looping-servicetask"});
        }

        @Test
        void testHasVersionFailure() throws InterruptedException, TimeoutException {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessAssert processAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByBpmnProcessId("looping-servicetask");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> processAssert.hasVersion(12345L)).isInstanceOf(AssertionError.class)).hasMessage("Expected version to be 12345 but was 1 instead");
        }

        @Test
        void testHasResourceNameFailure() throws InterruptedException, TimeoutException {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessAssert processAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByBpmnProcessId("looping-servicetask");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> processAssert.hasResourceName(AbstractProcessAssertTest.WRONG_VALUE)).isInstanceOf(AssertionError.class)).hasMessage("Expected resource name to be '%s' but was '%s' instead.", new Object[]{AbstractProcessAssertTest.WRONG_VALUE, "looping-servicetask.bpmn"});
        }

        @Test
        void testHasAnyInstancesFailure() throws InterruptedException, TimeoutException {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessAssert processAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByBpmnProcessId("looping-servicetask");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ProcessAssert)processAssert).hasAnyInstances()).isInstanceOf(AssertionError.class)).hasMessage("The process has no instances");
        }

        @Test
        void testHasNoInstances() throws InterruptedException, TimeoutException {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ProcessAssert processAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByBpmnProcessId("looping-servicetask");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ProcessAssert)processAssert).hasNoInstances()).isInstanceOf(AssertionError.class)).hasMessage("The process does have instances");
        }

        @Test
        void testHasInstances() throws InterruptedException, TimeoutException {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ProcessAssert processAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByBpmnProcessId("looping-servicetask");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> processAssert.hasInstances(2L)).isInstanceOf(AssertionError.class)).hasMessage("Expected number of instances to be 2 but was 3 instead");
        }
    }

    @Nested
    class HappyPathTests {
        private ZeebeClient client;
        private ZeebeTestEngine engine;

        HappyPathTests() {
        }

        @Test
        void testHasBPMNProcessId() throws InterruptedException, TimeoutException {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessAssert processAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByBpmnProcessId("looping-servicetask");
            processAssert.hasBpmnProcessId("looping-servicetask");
        }

        @Test
        void testHasVersion() throws InterruptedException, TimeoutException {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessAssert processAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByBpmnProcessId("looping-servicetask");
            processAssert.hasVersion(1L);
        }

        @Test
        void testHasResourceName() throws InterruptedException, TimeoutException {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessAssert processAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByBpmnProcessId("looping-servicetask");
            processAssert.hasResourceName("looping-servicetask.bpmn");
        }

        @Test
        void testHasAnyInstances() throws InterruptedException, TimeoutException {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ProcessAssert processAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByBpmnProcessId("looping-servicetask");
            processAssert.hasAnyInstances();
        }

        @Test
        void testHasNoInstances() throws InterruptedException, TimeoutException {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessAssert processAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByBpmnProcessId("looping-servicetask");
            processAssert.hasNoInstances();
        }

        @Test
        void testHasInstances() throws InterruptedException, TimeoutException {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ProcessAssert processAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByBpmnProcessId("looping-servicetask");
            processAssert.hasInstances(2L);
        }
    }
}

