/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.assertions;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.api.response.PublishMessageResponse;
import io.camunda.zeebe.process.test.api.RecordStreamSource;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public abstract class AbstractMessageAssertTest {
    public static final String CORRELATION_KEY = "correlationkey";
    public static final String WRONG_CORRELATION_KEY = "wrongcorrelationkey";
    public static final String WRONG_MESSAGE_NAME = "wrongmessagename";

    @Nested
    class UnhappyPathTests {
        private ZeebeClient client;
        private ZeebeTestEngine engine;

        UnhappyPathTests() {
        }

        @Test
        void testHasBeenCorrelatedFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, "message", AbstractMessageAssertTest.CORRELATION_KEY);
            ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> BpmnAssert.assertThat((PublishMessageResponse)response).hasBeenCorrelated()).isInstanceOf(AssertionError.class)).hasMessage("Message with key %d was not correlated", new Object[]{response.getMessageKey()});
        }

        @Test
        void testHasMessageStartEventBeenCorrelatedFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-start-event.bpmn");
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, AbstractMessageAssertTest.WRONG_MESSAGE_NAME, "");
            ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> BpmnAssert.assertThat((PublishMessageResponse)response).hasCreatedProcessInstance()).isInstanceOf(AssertionError.class)).hasMessage("Message with key %d did not lead to the creation of a process instance", new Object[]{response.getMessageKey()});
        }

        @Test
        void testHasNotBeenCorrelatedFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            Map<String, Object> variables = Collections.singletonMap("correlationKey", AbstractMessageAssertTest.CORRELATION_KEY);
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "message-event", variables);
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, "message", AbstractMessageAssertTest.CORRELATION_KEY);
            ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> BpmnAssert.assertThat((PublishMessageResponse)response).hasNotBeenCorrelated()).isInstanceOf(AssertionError.class)).hasMessage("Message with key %d was correlated to process instance %s", new Object[]{response.getMessageKey(), instanceEvent.getProcessInstanceKey()});
        }

        @Test
        void testHasMessageStartEventNotBeenCorrelatedFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-start-event.bpmn");
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, "start-message", "");
            ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> BpmnAssert.assertThat((PublishMessageResponse)response).hasNotCreatedProcessInstance()).isInstanceOf(AssertionError.class)).hasMessageContaining("Message with key %d was correlated to process instance", new Object[]{response.getMessageKey()});
        }

        @Test
        void testHasExpiredFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, "message", AbstractMessageAssertTest.CORRELATION_KEY, Duration.ofMinutes(1L), Collections.emptyMap());
            ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> BpmnAssert.assertThat((PublishMessageResponse)response).hasExpired()).isInstanceOf(AssertionError.class)).hasMessage("Message with key %d has not expired", new Object[]{response.getMessageKey()});
        }

        @Test
        void testHasNotExpiredFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            Duration timeToLive = Duration.ofDays(1L);
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, "message", AbstractMessageAssertTest.CORRELATION_KEY, timeToLive, Collections.emptyMap());
            Utilities.increaseTime(this.engine, timeToLive.plusMinutes(1L));
            try {
                ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> BpmnAssert.assertThat((PublishMessageResponse)response).hasNotExpired()).isInstanceOf(AssertionError.class)).hasMessage("Message with key %d has expired", new Object[]{response.getMessageKey()});
            }
            catch (Exception e) {
                RecordStream.of((RecordStreamSource)this.engine.getRecordStreamSource()).print(true);
                throw e;
            }
        }

        @Test
        void testExtractingProcessInstanceFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            Map<String, Object> variables = Collections.singletonMap("correlationKey", AbstractMessageAssertTest.CORRELATION_KEY);
            Utilities.startProcessInstance(this.engine, this.client, "message-event", variables);
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, "message", AbstractMessageAssertTest.WRONG_CORRELATION_KEY);
            ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> BpmnAssert.assertThat((PublishMessageResponse)response).extractingProcessInstance()).isInstanceOf(AssertionError.class)).hasMessage("Expected to find one correlated process instance for message key %d but found %d: %s", new Object[]{response.getMessageKey(), 0, "[]"});
        }

        @Test
        void testExtractingProcessInstanceFailure_messageStartEvent() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-start-event.bpmn");
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, AbstractMessageAssertTest.WRONG_MESSAGE_NAME, "");
            ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> BpmnAssert.assertThat((PublishMessageResponse)response).extractingProcessInstance()).isInstanceOf(AssertionError.class)).hasMessage("Expected to find one correlated process instance for message key %d but found %d: %s", new Object[]{response.getMessageKey(), 0, "[]"});
        }
    }

    @Nested
    class HappyPathTests {
        private ZeebeClient client;
        private ZeebeTestEngine engine;

        HappyPathTests() {
        }

        @Test
        void testHasBeenCorrelated() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            Map<String, Object> variables = Collections.singletonMap("correlationKey", AbstractMessageAssertTest.CORRELATION_KEY);
            Utilities.startProcessInstance(this.engine, this.client, "message-event", variables);
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, "message", AbstractMessageAssertTest.CORRELATION_KEY);
            BpmnAssert.assertThat((PublishMessageResponse)response).hasBeenCorrelated();
        }

        @Test
        void testHasMessageStartEventBeenCorrelated() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-start-event.bpmn");
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, "start-message", "");
            BpmnAssert.assertThat((PublishMessageResponse)response).hasCreatedProcessInstance();
        }

        @Test
        void testHasNotBeenCorrelated() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, "message", AbstractMessageAssertTest.CORRELATION_KEY);
            BpmnAssert.assertThat((PublishMessageResponse)response).hasNotBeenCorrelated();
        }

        @Test
        void testHasMessageStartEventNotBeenCorrelated() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-start-event.bpmn");
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, AbstractMessageAssertTest.WRONG_MESSAGE_NAME, "");
            BpmnAssert.assertThat((PublishMessageResponse)response).hasNotCreatedProcessInstance();
        }

        @Test
        void testHasExpired() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            Duration timeToLive = Duration.ofDays(1L);
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, "message", AbstractMessageAssertTest.CORRELATION_KEY, timeToLive, Collections.emptyMap());
            Utilities.increaseTime(this.engine, timeToLive.plusMinutes(1L));
            BpmnAssert.assertThat((PublishMessageResponse)response).hasExpired();
        }

        @Test
        void testHasNotExpired() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, "message", AbstractMessageAssertTest.CORRELATION_KEY, Duration.ofMinutes(1L), Collections.emptyMap());
            BpmnAssert.assertThat((PublishMessageResponse)response).hasNotExpired();
        }

        @Test
        void testExtractingProcessInstance() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-event.bpmn");
            Map<String, Object> variables = Collections.singletonMap("correlationKey", AbstractMessageAssertTest.CORRELATION_KEY);
            Utilities.startProcessInstance(this.engine, this.client, "message-event", variables);
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, "message", AbstractMessageAssertTest.CORRELATION_KEY);
            BpmnAssert.assertThat((PublishMessageResponse)response).extractingProcessInstance().isCompleted();
        }

        @Test
        void testExtractingProcessInstance_messageStartEvent() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "message-start-event.bpmn");
            PublishMessageResponse response = Utilities.sendMessage(this.engine, this.client, "start-message", "");
            BpmnAssert.assertThat((PublishMessageResponse)response).extractingProcessInstance().isCompleted();
        }
    }
}

