/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.assertions;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ActivateJobsResponse;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.assertions.IncidentAssert;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public abstract class AbstractJobAssertTest {
    public static final String WRONG_VALUE = "wrong value";
    public static final String ERROR_CODE = "error";
    public static final String ERROR_MSG = "error occurred";

    @Nested
    class UnhappyPathTests {
        private ZeebeClient client;
        private ZeebeTestEngine engine;

        UnhappyPathTests() {
        }

        @Test
        void testHasElementIdFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ActivatedJob)actual).hasElementId(AbstractJobAssertTest.WRONG_VALUE)).isInstanceOf(AssertionError.class)).hasMessage("Job is not associated with expected element id '%s' but is instead associated with '%s'.", new Object[]{AbstractJobAssertTest.WRONG_VALUE, "servicetask"});
        }

        @Test
        void testHasDeadlineFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            long expectedDeadline = System.currentTimeMillis() + 100L;
            ActivateJobsResponse jobActivationResponse = (ActivateJobsResponse)this.client.newActivateJobsCommand().jobType("test").maxJobsToActivate(1).timeout(Duration.ofMillis(100L)).send().join();
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ActivatedJob)actual).hasDeadline(-1L, Offset.offset((Number)20L))).isInstanceOf(AssertionError.class)).hasMessageContainingAll(new CharSequence[]{"Deadline", "-1", "20"});
        }

        @Test
        void testHasBpmnProcessIdFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ActivatedJob)actual).hasBpmnProcessId(AbstractJobAssertTest.WRONG_VALUE)).isInstanceOf(AssertionError.class)).hasMessage("Job is not associated with BPMN process id '%s' but is instead associated with '%s'.", new Object[]{AbstractJobAssertTest.WRONG_VALUE, "looping-servicetask"});
        }

        @Test
        void testHasRetriesFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ActivatedJob)actual).hasRetries(12345)).isInstanceOf(AssertionError.class)).hasMessage("Job does not have %d retries, as expected, but instead has %d retries.", new Object[]{12345, 1});
        }

        @Test
        void testHasAnyIncidentsFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ActivatedJob)actual).hasAnyIncidents()).isInstanceOf(AssertionError.class)).hasMessage("No incidents were raised for this job");
        }

        @Test
        void testHasNoIncidentsFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, actual.getKey(), AbstractJobAssertTest.ERROR_CODE, AbstractJobAssertTest.ERROR_MSG);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ActivatedJob)actual).hasNoIncidents()).isInstanceOf(AssertionError.class)).hasMessage("Incidents were raised for this job");
        }

        @Test
        void testExtractLatestIncidentFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((ActivatedJob)actual).extractingLatestIncident()).isInstanceOf(AssertionError.class)).hasMessage("No incidents were raised for this job");
        }
    }

    @Nested
    class HappyPathTests {
        private ZeebeClient client;
        private ZeebeTestEngine engine;

        HappyPathTests() {
        }

        @Test
        void testHasElementId() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            BpmnAssert.assertThat((ActivatedJob)actual).hasElementId("servicetask");
        }

        @Test
        void testHasDeadline() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            long expectedDeadline = System.currentTimeMillis() + 100L;
            ActivateJobsResponse jobActivationResponse = (ActivateJobsResponse)this.client.newActivateJobsCommand().jobType("test").maxJobsToActivate(1).timeout(Duration.ofMillis(100L)).send().join();
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            BpmnAssert.assertThat((ActivatedJob)actual).hasDeadline(expectedDeadline, Offset.offset((Number)50L));
        }

        @Test
        void testHasBpmnProcessId() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            BpmnAssert.assertThat((ActivatedJob)actual).hasBpmnProcessId("looping-servicetask");
        }

        @Test
        void testHasRetries() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            BpmnAssert.assertThat((ActivatedJob)actual).hasRetries(1);
        }

        @Test
        void testHasAnyIncidents() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, actual.getKey(), AbstractJobAssertTest.ERROR_CODE, AbstractJobAssertTest.ERROR_MSG);
            BpmnAssert.assertThat((ActivatedJob)actual).hasAnyIncidents();
        }

        @Test
        void testHasNoIncidents() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            BpmnAssert.assertThat((ActivatedJob)actual).hasNoIncidents();
        }

        @Test
        void testExtractLatestIncident() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, actual.getKey(), AbstractJobAssertTest.ERROR_CODE, AbstractJobAssertTest.ERROR_MSG);
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ActivatedJob)actual).extractingLatestIncident();
            Assertions.assertThat((Object)incidentAssert).isNotNull();
            incidentAssert.isUnresolved().hasErrorType(ErrorType.UNHANDLED_ERROR_EVENT).occurredDuringJob(actual);
        }

        @Test
        void testExtractingVariables() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            BpmnAssert.assertThat((ActivatedJob)actual).extractingVariables().containsOnly(new Map.Entry[]{Assertions.entry((Object)"totalLoops", (Object)1), Assertions.entry((Object)"loopAmount", (Object)0)});
        }

        @Test
        void testExtractingHeaders() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", 1);
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            BpmnAssert.assertThat((ActivatedJob)actual).extractingHeaders().isEmpty();
        }
    }
}

