/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.assertions;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ActivateJobsResponse;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.assertions.IncidentAssert;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.StringAssert;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public abstract class AbstractIncidentAssertTest {
    public static final String WRONG_VALUE = "wrong value";
    public static final String ERROR_CODE = "error";
    public static final String ERROR_MESSAGE = "error occurred";

    @Nested
    class UnhappyPathTests {
        private ZeebeClient client;
        private ZeebeTestEngine engine;

        UnhappyPathTests() {
        }

        @Test
        void testHasErrorTypeFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, actual.getKey(), AbstractIncidentAssertTest.ERROR_CODE, AbstractIncidentAssertTest.ERROR_MESSAGE);
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ActivatedJob)actual).extractingLatestIncident();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> incidentAssert.hasErrorType(ErrorType.IO_MAPPING_ERROR)).isInstanceOf(AssertionError.class)).hasMessageStartingWith("Error type was not 'IO_MAPPING_ERROR' but was 'UNHANDLED_ERROR_EVENT' instead");
        }

        @Test
        void testHasErrorMessageFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, actual.getKey(), AbstractIncidentAssertTest.ERROR_CODE, AbstractIncidentAssertTest.ERROR_MESSAGE);
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ActivatedJob)actual).extractingLatestIncident();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> incidentAssert.hasErrorMessage(AbstractIncidentAssertTest.WRONG_VALUE)).isInstanceOf(AssertionError.class)).hasMessageStartingWith("Error message was not 'wrong value' but was 'Expected to throw an error event with the code 'error' with message 'error occurred', but it was not caught. No error events are available in the scope.' instead");
        }

        @Test
        void testWasRaisedInProcessInstanceFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent processInstanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, actual.getKey(), AbstractIncidentAssertTest.ERROR_CODE, AbstractIncidentAssertTest.ERROR_MESSAGE);
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ActivatedJob)actual).extractingLatestIncident();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> incidentAssert.wasRaisedInProcessInstance(-1L)).isInstanceOf(AssertionError.class)).hasMessageStartingWith("Incident was not raised in process instance -1 but was raised in %d instead", new Object[]{processInstanceEvent.getProcessInstanceKey()});
        }

        @Test
        void testOccurredOnElementFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", "invalid value");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob job = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            this.client.newCompleteCommand(job.getKey()).send().join();
            Utilities.waitForIdleState(this.engine, Duration.ofSeconds(1L));
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).extractingLatestIncident();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> incidentAssert.occurredOnElement(AbstractIncidentAssertTest.WRONG_VALUE)).isInstanceOf(AssertionError.class)).hasMessageStartingWith("Error type was not raised on element '%s' but was raised on '%s' instead", new Object[]{AbstractIncidentAssertTest.WRONG_VALUE, "Gateway_0fhwf5d"});
        }

        @Test
        void testOccurredDuringJobFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob job = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, job.getKey(), AbstractIncidentAssertTest.ERROR_CODE, AbstractIncidentAssertTest.ERROR_MESSAGE);
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ActivatedJob)job).extractingLatestIncident();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> incidentAssert.occurredDuringJob(-1L)).isInstanceOf(AssertionError.class)).hasMessageStartingWith("Incident was not raised during job instance -1 but was raised in %d instead", new Object[]{job.getKey()});
        }

        @Test
        void testIsResolvedFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, actual.getKey(), AbstractIncidentAssertTest.ERROR_CODE, AbstractIncidentAssertTest.ERROR_MESSAGE);
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ActivatedJob)actual).extractingLatestIncident();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((IncidentAssert)incidentAssert).isResolved()).isInstanceOf(AssertionError.class)).hasMessageStartingWith("Incident is not resolved");
        }

        @Test
        void testIsUnresolvedFailure() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, actual.getKey(), AbstractIncidentAssertTest.ERROR_CODE, AbstractIncidentAssertTest.ERROR_MESSAGE);
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ActivatedJob)actual).extractingLatestIncident();
            long incidentKey = incidentAssert.getIncidentKey();
            this.client.newResolveIncidentCommand(incidentKey).send().join();
            Utilities.waitForIdleState(this.engine, Duration.ofSeconds(1L));
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((IncidentAssert)incidentAssert).isUnresolved()).isInstanceOf(AssertionError.class)).hasMessageStartingWith("Incident is already resolved");
        }
    }

    @Nested
    class HappyPathTests {
        private ZeebeClient client;
        private ZeebeTestEngine engine;

        HappyPathTests() {
        }

        @Test
        void testHasErrorType() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, actual.getKey(), AbstractIncidentAssertTest.ERROR_CODE, AbstractIncidentAssertTest.ERROR_MESSAGE);
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ActivatedJob)actual).extractingLatestIncident();
            incidentAssert.hasErrorType(ErrorType.UNHANDLED_ERROR_EVENT);
        }

        @Test
        void testHasErrorMessage() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, actual.getKey(), AbstractIncidentAssertTest.ERROR_CODE, AbstractIncidentAssertTest.ERROR_MESSAGE);
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ActivatedJob)actual).extractingLatestIncident();
            incidentAssert.hasErrorMessage("Expected to throw an error event with the code 'error' with message 'error occurred', but it was not caught. No error events are available in the scope.");
        }

        @Test
        void testExtractErrorMessage() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, actual.getKey(), AbstractIncidentAssertTest.ERROR_CODE, AbstractIncidentAssertTest.ERROR_MESSAGE);
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ActivatedJob)actual).extractingLatestIncident();
            StringAssert messageAssert = incidentAssert.extractingErrorMessage();
            Assertions.assertThat((Object)messageAssert).isNotNull();
            messageAssert.isEqualTo("Expected to throw an error event with the code 'error' with message 'error occurred', but it was not caught. No error events are available in the scope.");
        }

        @Test
        void testWasRaisedInProcessInstance() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent processInstanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, actual.getKey(), AbstractIncidentAssertTest.ERROR_CODE, AbstractIncidentAssertTest.ERROR_MESSAGE);
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ActivatedJob)actual).extractingLatestIncident();
            incidentAssert.wasRaisedInProcessInstance(processInstanceEvent);
            incidentAssert.wasRaisedInProcessInstance(processInstanceEvent.getProcessInstanceKey());
        }

        @Test
        void testOccurredOnElement() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Map<String, Object> variables = Collections.singletonMap("totalLoops", "invalid value");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", variables);
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob job = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            this.client.newCompleteCommand(job.getKey()).send().join();
            Utilities.waitForIdleState(this.engine, Duration.ofSeconds(1L));
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).extractingLatestIncident();
            incidentAssert.occurredOnElement("Gateway_0fhwf5d");
        }

        @Test
        void testOccurredDuringJob() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob job = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, job.getKey(), AbstractIncidentAssertTest.ERROR_CODE, AbstractIncidentAssertTest.ERROR_MESSAGE);
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ActivatedJob)job).extractingLatestIncident();
            incidentAssert.occurredDuringJob(job);
            incidentAssert.occurredDuringJob(job.getKey());
        }

        @Test
        void testIsResolved() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, actual.getKey(), AbstractIncidentAssertTest.ERROR_CODE, AbstractIncidentAssertTest.ERROR_MESSAGE);
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ActivatedJob)actual).extractingLatestIncident();
            long incidentKey = incidentAssert.getIncidentKey();
            this.client.newResolveIncidentCommand(incidentKey).send().join();
            Utilities.waitForIdleState(this.engine, Duration.ofSeconds(1L));
            incidentAssert.isResolved();
        }

        @Test
        void testIsUnresolved() throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask");
            ActivateJobsResponse jobActivationResponse = Utilities.activateSingleJob(this.client, "test");
            ActivatedJob actual = (ActivatedJob)jobActivationResponse.getJobs().get(0);
            Utilities.throwErrorCommand(this.engine, this.client, actual.getKey(), AbstractIncidentAssertTest.ERROR_CODE, AbstractIncidentAssertTest.ERROR_MESSAGE);
            IncidentAssert incidentAssert = BpmnAssert.assertThat((ActivatedJob)actual).extractingLatestIncident();
            incidentAssert.isUnresolved();
        }
    }
}

