/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.assertions;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.assertions.FormAssert;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class AbstractFormAssertTest {
    public static final String WRONG_VALUE = "wrong value";

    @Nested
    class UnhappyPathTests {
        private ZeebeClient client;
        private ZeebeTestEngine engine;

        UnhappyPathTests() {
        }

        @Test
        void shouldHaveFormIdFailure() {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "test-form.form");
            FormAssert formAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingFormByFormId("Form_0w7r08e");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> formAssert.hasFormId(AbstractFormAssertTest.WRONG_VALUE)).isInstanceOf(AssertionError.class)).hasMessage("Expected form id to be '%s' but was '%s' instead.", new Object[]{AbstractFormAssertTest.WRONG_VALUE, "Form_0w7r08e"});
        }

        @Test
        void shouldHaveVersionFailure() {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "test-form.form");
            FormAssert formAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingFormByFormId("Form_0w7r08e");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> formAssert.hasVersion(2L)).isInstanceOf(AssertionError.class)).hasMessage("Expected version to be 2 but was 1 instead");
        }

        @Test
        void shouldHaveResourceName() {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "test-form.form");
            FormAssert formAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingFormByResourceName("test-form.form");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> formAssert.hasResourceName(AbstractFormAssertTest.WRONG_VALUE)).isInstanceOf(AssertionError.class)).hasMessage("Expected resource name to be '%s' but was '%s' instead.", new Object[]{AbstractFormAssertTest.WRONG_VALUE, "test-form.form"});
        }

        @Test
        void shouldNotFoundCreatedForm() throws InterruptedException, TimeoutException {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "test-form.form");
            FormAssert formAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingFormByFormId("Form_0w7r08e");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> formAssert.isFormCreated(AbstractFormAssertTest.WRONG_VALUE)).isInstanceOf(AssertionError.class)).hasMessage("Expected to find a form with id to be '%s', but no form with the provided id was found.", new Object[]{AbstractFormAssertTest.WRONG_VALUE});
        }
    }

    @Nested
    class HappyPathTests {
        private ZeebeClient client;
        private ZeebeTestEngine engine;

        HappyPathTests() {
        }

        @Test
        void shouldHaveFormId() {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "test-form.form");
            FormAssert formAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingFormByFormId("Form_0w7r08e");
            formAssert.hasFormId("Form_0w7r08e");
        }

        @Test
        void shouldHaveVersion() {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "test-form.form");
            FormAssert formAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingFormByFormId("Form_0w7r08e");
            formAssert.hasVersion(1L);
        }

        @Test
        void shouldHaveResourceName() {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "test-form.form");
            FormAssert formAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingFormByFormId("Form_0w7r08e");
            formAssert.hasResourceName("test-form.form");
        }

        @Test
        void shouldFindDeployedForm() throws InterruptedException, TimeoutException {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "test-form.form");
            this.engine.waitForIdleState(Duration.ofSeconds(1L));
            FormAssert formAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingFormByFormId("Form_0w7r08e");
            formAssert.isFormCreated("Form_0w7r08e");
        }
    }
}

