/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.assertions;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.assertions.ProcessAssert;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public abstract class AbstractDeploymentAssertTest {
    public static final String WRONG_VALUE = "wrong value";

    @Nested
    class UnhappyPathTests {
        private ZeebeClient client;

        UnhappyPathTests() {
        }

        @Test
        void testContainsProcessesByIdFailure() {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).containsProcessesByBpmnProcessId(new String[]{AbstractDeploymentAssertTest.WRONG_VALUE})).isInstanceOf(AssertionError.class)).hasMessageContainingAll(new CharSequence[]{AbstractDeploymentAssertTest.WRONG_VALUE, "looping-servicetask"});
        }

        @Test
        void testContainsProcessesByResourceNameFailure() {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).containsProcessesByResourceName(new String[]{AbstractDeploymentAssertTest.WRONG_VALUE})).isInstanceOf(AssertionError.class)).hasMessageContainingAll(new CharSequence[]{AbstractDeploymentAssertTest.WRONG_VALUE, "looping-servicetask"});
        }

        @Test
        void testExtractingProcessByBpmnProcessIdFailure() {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByBpmnProcessId(AbstractDeploymentAssertTest.WRONG_VALUE)).isInstanceOf(AssertionError.class)).hasMessage("Expected to find one process for BPMN process id 'wrong value' but found 0: []");
        }

        @Test
        void testExtractingProcessByResourceName() {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByResourceName(AbstractDeploymentAssertTest.WRONG_VALUE)).isInstanceOf(AssertionError.class)).hasMessage("Expected to find one process for resource name 'wrong value' but found 0: []");
        }
    }

    @Nested
    class HappyPathTests {
        private ZeebeClient client;

        HappyPathTests() {
        }

        @Test
        void testContainsProcessesById() {
            DeploymentEvent deploymentEvent = Utilities.deployResources(this.client, "looping-servicetask.bpmn", "multiple-tasks.bpmn");
            BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).containsProcessesByBpmnProcessId(new String[]{"looping-servicetask", "multiple-tasks"});
        }

        @Test
        void testContainsProcessesByResourceName() {
            DeploymentEvent deploymentEvent = Utilities.deployResources(this.client, "looping-servicetask.bpmn", "multiple-tasks.bpmn");
            BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).containsProcessesByResourceName(new String[]{"looping-servicetask.bpmn", "multiple-tasks.bpmn"});
        }

        @Test
        void testExtractingProcessByBpmnProcessId() {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessAssert processAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByBpmnProcessId("looping-servicetask");
            Assertions.assertThat((Object)processAssert).isNotNull();
        }

        @Test
        void testExtractingProcessByResourceName() {
            DeploymentEvent deploymentEvent = Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessAssert processAssert = BpmnAssert.assertThat((DeploymentEvent)deploymentEvent).extractingProcessByResourceName("looping-servicetask.bpmn");
            Assertions.assertThat((Object)processAssert).isNotNull();
        }
    }
}

