/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.qa.abstracts.assertions;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.qa.abstracts.util.Utilities;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class AbstractCustomObjectMapperTest {
    private static Stream<Arguments> provideVariables() {
        return Stream.of(Arguments.of((Object[])new Object[]{"stringProperty", "stringValue"}), Arguments.of((Object[])new Object[]{"booleanProperty", true}), Arguments.of((Object[])new Object[]{"complexProperty", Arrays.asList("Element 1", "Element 2")}), Arguments.of((Object[])new Object[]{"nullProperty", null}), Arguments.of((Object[])new Object[]{"javaDate", LocalDateTime.of(2023, 8, 14, 16, 0, 0)}), Arguments.of((Object[])new Object[]{"stringDate", "\"2023-08-14T16:00:00\""}));
    }

    @Nested
    class HappyPathTests {
        private ZeebeClient client;
        private ZeebeTestEngine engine;
        private final ObjectMapper objectMapper = this.configureObjectMapper();

        HappyPathTests() {
        }

        @ParameterizedTest
        @MethodSource(value={"io.camunda.zeebe.process.test.qa.abstracts.assertions.AbstractCustomObjectMapperTest#provideVariables"})
        public void shouldDeserializeDateVariables(String key, Object value) throws InterruptedException, TimeoutException {
            Utilities.deployResource(this.client, "looping-servicetask.bpmn");
            ProcessInstanceEvent instanceEvent = Utilities.startProcessInstance(this.engine, this.client, "looping-servicetask", Collections.singletonMap(key, value));
            Assertions.assertThatNoException().isThrownBy(() -> BpmnAssert.assertThat((ProcessInstanceEvent)instanceEvent).hasVariableWithValue(key, value));
        }

        private ObjectMapper configureObjectMapper() {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.registerModule((Module)new JavaTimeModule());
            objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            return objectMapper;
        }
    }
}

