/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.assertions;

import com.fasterxml.jackson.databind.JsonNode;
import io.camunda.client.impl.CamundaObjectMapper;
import io.camunda.zeebe.process.test.ObjectMapperConfig;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;

public class VariablesMapAssert
extends AbstractAssert<VariablesMapAssert, Map<String, String>> {
    private final CamundaObjectMapper objectMapper = ObjectMapperConfig.getObjectMapper();

    public VariablesMapAssert(Map<String, String> actual) {
        super(actual, VariablesMapAssert.class);
    }

    public VariablesMapAssert containsVariable(String name) {
        ((MapAssert)Assertions.assertThat((Map)((Map)this.actual)).withFailMessage("Unable to find variable with name `%s`. Available variables are: %s", new Object[]{name, ((Map)this.actual).keySet()})).containsKey((Object)name);
        return this;
    }

    public VariablesMapAssert hasVariableWithValue(String name, Object value) {
        this.containsVariable(name);
        String expectedValue = this.objectMapper.toJson(value);
        String actualValue = (String)((Map)this.actual).get(name);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.isEqual(actualValue, expectedValue)).withFailMessage("The variable '%s' does not have the expected value. The value passed in ('%s') is internally mapped to a JSON String that yields '%s'. However, the actual value (as JSON String) is '%s'.", new Object[]{name, value, expectedValue, actualValue})).isTrue();
        return this;
    }

    private boolean isEqual(String actualJson, String expectedJson) {
        return this.asJsonNode(actualJson).equals((Object)this.asJsonNode(expectedJson));
    }

    private JsonNode asJsonNode(String json) {
        return (JsonNode)this.objectMapper.fromJson(json, JsonNode.class);
    }
}

