/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.assertions;

import io.camunda.client.api.response.Form;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.process.test.filters.StreamFilter;
import io.camunda.zeebe.protocol.record.Record;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;

public class FormAssert
extends AbstractAssert<FormAssert, Form> {
    private final RecordStream recordStream;

    protected FormAssert(Form form, RecordStream recordStream) {
        super((Object)form, FormAssert.class);
        this.recordStream = recordStream;
    }

    public FormAssert hasFormId(String expectedFormId) {
        Assertions.assertThat((String)expectedFormId).isNotEmpty();
        String actualFormId = ((Form)this.actual).getFormId();
        ((AbstractStringAssert)Assertions.assertThat((String)actualFormId).withFailMessage("Expected form id to be '%s' but was '%s' instead.", new Object[]{expectedFormId, actualFormId})).isEqualTo(expectedFormId);
        return this;
    }

    public FormAssert hasFormKey(long expectedFormKey) {
        Assertions.assertThat((long)expectedFormKey).isPositive();
        long actualFormKey = ((Form)this.actual).getFormKey();
        ((AbstractLongAssert)Assertions.assertThat((long)actualFormKey).withFailMessage("Expected form id to be '%d' but was '%d' instead.", new Object[]{expectedFormKey, actualFormKey})).isEqualTo(expectedFormKey);
        return this;
    }

    public FormAssert hasVersion(long expectedVersion) {
        long actualVersion = ((Form)this.actual).getVersion();
        ((AbstractLongAssert)Assertions.assertThat((long)actualVersion).withFailMessage("Expected version to be %d but was %d instead", new Object[]{expectedVersion, actualVersion})).isEqualTo(expectedVersion);
        return this;
    }

    public FormAssert hasResourceName(String expectedResourceName) {
        Assertions.assertThat((String)expectedResourceName).isNotEmpty();
        String actualResourceName = ((Form)this.actual).getResourceName();
        ((AbstractStringAssert)Assertions.assertThat((String)actualResourceName).withFailMessage("Expected resource name to be '%s' but was '%s' instead.", new Object[]{expectedResourceName, actualResourceName})).isEqualTo(expectedResourceName);
        return this;
    }

    public FormAssert isFormCreated(String formId) {
        Assertions.assertThat((String)formId).isNotEmpty();
        boolean isCreated = StreamFilter.forms((RecordStream)this.recordStream).stream().map(Record::getValue).anyMatch(form -> formId.equals(form.getFormId()));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)isCreated).withFailMessage("Expected to find a form with id to be '%s', but no form with the provided id was found.", new Object[]{formId})).isTrue();
        return this;
    }
}

