/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.assertions;

import io.camunda.client.api.response.DeploymentEvent;
import io.camunda.client.api.response.Form;
import io.camunda.client.api.response.Process;
import io.camunda.zeebe.process.test.assertions.FormAssert;
import io.camunda.zeebe.process.test.assertions.ProcessAssert;
import io.camunda.zeebe.process.test.filters.RecordStream;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public class DeploymentAssert
extends AbstractAssert<DeploymentAssert, DeploymentEvent> {
    private final RecordStream recordStream;

    public DeploymentAssert(DeploymentEvent actual, RecordStream recordStream) {
        super((Object)actual, DeploymentAssert.class);
        this.recordStream = recordStream;
    }

    public DeploymentAssert containsProcessesByBpmnProcessId(String ... expectedBpmnProcessIds) {
        Assertions.assertThat((Object[])expectedBpmnProcessIds).isNotEmpty();
        List deployedProcesses = ((DeploymentEvent)this.actual).getProcesses().stream().map(Process::getBpmnProcessId).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(deployedProcesses).describedAs("Deployed Processes (BPMN process IDs)", new Object[0])).contains((Object[])expectedBpmnProcessIds);
        return this;
    }

    public DeploymentAssert containsProcessesByResourceName(String ... expectedProcessInstanceResourceNames) {
        Assertions.assertThat((Object[])expectedProcessInstanceResourceNames).isNotEmpty();
        List deployedProcesses = ((DeploymentEvent)this.actual).getProcesses().stream().map(Process::getResourceName).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(deployedProcesses).describedAs("Deployed Processes (resource name)", new Object[0])).contains((Object[])expectedProcessInstanceResourceNames);
        return this;
    }

    public ProcessAssert extractingProcessByBpmnProcessId(String bpmnProcessId) {
        ((AbstractStringAssert)Assertions.assertThat((String)bpmnProcessId).describedAs("Parameter 'bpmnProcessId'", new Object[0])).isNotEmpty();
        List matchingProcesses = ((DeploymentEvent)this.actual).getProcesses().stream().filter(process -> process.getBpmnProcessId().equals(bpmnProcessId)).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(matchingProcesses).withFailMessage("Expected to find one process for BPMN process id '%s' but found %d: %s", new Object[]{bpmnProcessId, matchingProcesses.size(), matchingProcesses})).hasSize(1);
        return new ProcessAssert((Process)matchingProcesses.get(0), this.recordStream);
    }

    public ProcessAssert extractingProcessByResourceName(String resourceName) {
        ((AbstractStringAssert)Assertions.assertThat((String)resourceName).describedAs("Parameter 'resourceName'", new Object[0])).isNotEmpty();
        List matchingProcesses = ((DeploymentEvent)this.actual).getProcesses().stream().filter(process -> process.getResourceName().equals(resourceName)).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(matchingProcesses).withFailMessage("Expected to find one process for resource name '%s' but found %d: %s", new Object[]{resourceName, matchingProcesses.size(), matchingProcesses})).hasSize(1);
        return new ProcessAssert((Process)matchingProcesses.get(0), this.recordStream);
    }

    public FormAssert extractingFormByFormId(String formId) {
        ((AbstractStringAssert)Assertions.assertThat((String)formId).describedAs("Parameter 'formId'", new Object[0])).isNotEmpty();
        List matchingForm = ((DeploymentEvent)this.actual).getForm().stream().filter(form -> form.getFormId().equals(formId)).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(matchingForm).withFailMessage("Expected to find one form for formId '%s' but found %d: %s", new Object[]{formId, matchingForm.size(), matchingForm})).hasSize(1);
        return new FormAssert((Form)matchingForm.get(0), this.recordStream);
    }

    public FormAssert extractingFormByResourceName(String resourceName) {
        ((AbstractStringAssert)Assertions.assertThat((String)resourceName).describedAs("Parameter 'resourceName'", new Object[0])).isNotEmpty();
        List matchingForm = ((DeploymentEvent)this.actual).getForm().stream().filter(form -> form.getResourceName().equals(resourceName)).collect(Collectors.toList());
        ((ListAssert)Assertions.assertThat(matchingForm).withFailMessage("Expected to find one form for resource name '%s' but found %d: %s", new Object[]{resourceName, matchingForm.size(), matchingForm})).hasSize(1);
        return new FormAssert((Form)matchingForm.get(0), this.recordStream);
    }
}

