/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.assertions;

import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.response.DeploymentEvent;
import io.camunda.client.api.response.ProcessInstanceEvent;
import io.camunda.client.api.response.ProcessInstanceResult;
import io.camunda.client.api.response.PublishMessageResponse;
import io.camunda.zeebe.process.test.assertions.DeploymentAssert;
import io.camunda.zeebe.process.test.assertions.JobAssert;
import io.camunda.zeebe.process.test.assertions.MessageAssert;
import io.camunda.zeebe.process.test.assertions.ProcessInstanceAssert;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.process.test.inspections.model.InspectedProcessInstance;

public abstract class BpmnAssert {
    static ThreadLocal<RecordStream> recordStream = new ThreadLocal();

    public static void initRecordStream(RecordStream recordStream) {
        BpmnAssert.recordStream.set(recordStream);
    }

    public static void resetRecordStream() {
        recordStream.remove();
    }

    public static RecordStream getRecordStream() {
        if (recordStream.get() == null) {
            throw new AssertionError((Object)"No RecordStream is set. Please make sure you are using the @ZeebeProcessTest annotation. Alternatively, set one manually using BpmnAssert.initRecordStream.");
        }
        return recordStream.get();
    }

    public static ProcessInstanceAssert assertThat(ProcessInstanceEvent instanceEvent) {
        return new ProcessInstanceAssert(instanceEvent.getProcessInstanceKey(), BpmnAssert.getRecordStream());
    }

    public static ProcessInstanceAssert assertThat(ProcessInstanceResult instanceResult) {
        return new ProcessInstanceAssert(instanceResult.getProcessInstanceKey(), BpmnAssert.getRecordStream());
    }

    public static ProcessInstanceAssert assertThat(InspectedProcessInstance inspectedProcessInstance) {
        return new ProcessInstanceAssert(inspectedProcessInstance.getProcessInstanceKey(), BpmnAssert.getRecordStream());
    }

    public static JobAssert assertThat(ActivatedJob activatedJob) {
        return new JobAssert(activatedJob, BpmnAssert.getRecordStream());
    }

    public static DeploymentAssert assertThat(DeploymentEvent deploymentEvent) {
        return new DeploymentAssert(deploymentEvent, BpmnAssert.getRecordStream());
    }

    public static MessageAssert assertThat(PublishMessageResponse publishMessageResponse) {
        return new MessageAssert(publishMessageResponse, BpmnAssert.getRecordStream());
    }
}

