/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.assertions;

import io.camunda.client.api.response.ActivatedJob;
import io.camunda.zeebe.process.test.assertions.IncidentAssert;
import io.camunda.zeebe.process.test.filters.IncidentRecordStreamFilter;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.process.test.filters.StreamFilter;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.data.Offset;

public class JobAssert
extends AbstractAssert<JobAssert, ActivatedJob> {
    private final RecordStream recordStream;

    public JobAssert(ActivatedJob actual, RecordStream recordStream) {
        super((Object)actual, JobAssert.class);
        this.recordStream = recordStream;
    }

    public JobAssert hasElementId(String expectedElementId) {
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)expectedElementId).describedAs("expectedElementId", new Object[0])).isNotNull()).isNotEmpty();
        String actualElementId = ((ActivatedJob)this.actual).getElementId();
        ((AbstractStringAssert)Assertions.assertThat((String)actualElementId).withFailMessage("Job is not associated with expected element id '%s' but is instead associated with '%s'.", new Object[]{expectedElementId, actualElementId})).isEqualTo(expectedElementId);
        return this;
    }

    public JobAssert hasDeadline(long expectedDeadline, Offset<Long> offset) {
        ((ObjectAssert)Assertions.assertThat(offset).describedAs("Offset", new Object[0])).isNotNull();
        long actualDeadline = ((ActivatedJob)this.actual).getDeadline();
        ((AbstractLongAssert)Assertions.assertThat((long)actualDeadline).describedAs("Deadline", new Object[0])).isCloseTo(expectedDeadline, offset);
        return this;
    }

    public JobAssert hasBpmnProcessId(String expectedBpmnProcessId) {
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)expectedBpmnProcessId).describedAs("expectedBpmnProcessId", new Object[0])).isNotNull()).isNotEmpty();
        String actualBpmnProcessId = ((ActivatedJob)this.actual).getBpmnProcessId();
        ((AbstractStringAssert)Assertions.assertThat((String)actualBpmnProcessId).withFailMessage("Job is not associated with BPMN process id '%s' but is instead associated with '%s'.", new Object[]{expectedBpmnProcessId, actualBpmnProcessId})).isEqualTo(expectedBpmnProcessId);
        return this;
    }

    public JobAssert hasRetries(int expectedRetries) {
        int actualRetries = ((ActivatedJob)this.actual).getRetries();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualRetries).withFailMessage("Job does not have %d retries, as expected, but instead has %d retries.", new Object[]{expectedRetries, actualRetries})).isEqualTo(expectedRetries);
        return this;
    }

    public JobAssert hasAnyIncidents() {
        boolean incidentsWereRaised = this.getIncidentCreatedRecords().stream().findFirst().isPresent();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)incidentsWereRaised).withFailMessage("No incidents were raised for this job", new Object[0])).isTrue();
        return this;
    }

    public JobAssert hasNoIncidents() {
        boolean incidentsWereRaised = this.getIncidentCreatedRecords().stream().findFirst().isPresent();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)incidentsWereRaised).withFailMessage("Incidents were raised for this job", new Object[0])).isFalse();
        return this;
    }

    public IncidentAssert extractingLatestIncident() {
        this.hasAnyIncidents();
        List incidentCreatedRecords = this.getIncidentCreatedRecords().stream().collect(Collectors.toList());
        Record latestIncidentRecord = (Record)incidentCreatedRecords.get(incidentCreatedRecords.size() - 1);
        return new IncidentAssert(latestIncidentRecord.getKey(), this.recordStream);
    }

    private IncidentRecordStreamFilter getIncidentCreatedRecords() {
        return StreamFilter.incident((RecordStream)this.recordStream).withRejectionType(RejectionType.NULL_VAL).withJobKey(((ActivatedJob)this.actual).getKey());
    }

    public MapAssert<String, Object> extractingVariables() {
        return (MapAssert)Assertions.assertThat((Map)((ActivatedJob)this.actual).getVariablesAsMap()).describedAs("Variables", new Object[0]);
    }

    public MapAssert<String, String> extractingHeaders() {
        return (MapAssert)Assertions.assertThat((Map)((ActivatedJob)this.actual).getCustomHeaders()).describedAs("Headers", new Object[0]);
    }
}

