/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.assertions;

import io.camunda.client.api.response.ActivatedJob;
import io.camunda.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.process.test.filters.IncidentRecordStreamFilter;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.process.test.filters.StreamFilter;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import java.util.Optional;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.StringAssert;

public class IncidentAssert
extends AbstractAssert<IncidentAssert, Long> {
    private final String LINE_SEPARATOR = System.lineSeparator();
    private final RecordStream recordStream;

    public IncidentAssert(long incidentKey, RecordStream recordStream) {
        super((Object)incidentKey, IncidentAssert.class);
        this.recordStream = recordStream;
    }

    public long getIncidentKey() {
        return (Long)this.actual;
    }

    public IncidentAssert hasErrorType(ErrorType expectedErrorType) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)expectedErrorType).describedAs("Parameter 'expectedErrorType", new Object[0])).isNotNull();
        IncidentRecordValue record = this.getIncidentCreatedRecordValue();
        ErrorType actualErrorType = record.getErrorType();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actualErrorType).withFailMessage("Error type was not '%s' but was '%s' instead.%s", new Object[]{expectedErrorType, actualErrorType, this.composeIncidentDetails()})).isEqualTo((Object)expectedErrorType);
        return this;
    }

    public IncidentAssert hasErrorMessage(String expectedErrorMessage) {
        IncidentRecordValue record = this.getIncidentCreatedRecordValue();
        String actualErrorMessage = record.getErrorMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)actualErrorMessage).withFailMessage("Error message was not '%s' but was '%s' instead.%s", new Object[]{expectedErrorMessage, actualErrorMessage, this.composeIncidentDetails()})).isEqualTo(expectedErrorMessage);
        return this;
    }

    public StringAssert extractingErrorMessage() {
        IncidentRecordValue record = this.getIncidentCreatedRecordValue();
        String actualErrorMessage = record.getErrorMessage();
        return new StringAssert(actualErrorMessage);
    }

    public IncidentAssert wasRaisedInProcessInstance(ProcessInstanceEvent expectedProcessInstance) {
        Assertions.assertThat((Object)expectedProcessInstance).isNotNull();
        return this.wasRaisedInProcessInstance(expectedProcessInstance.getProcessInstanceKey());
    }

    public IncidentAssert wasRaisedInProcessInstance(long expectedProcessInstanceKey) {
        IncidentRecordValue record = this.getIncidentCreatedRecordValue();
        long actualProcessInstanceKey = record.getProcessInstanceKey();
        ((AbstractLongAssert)Assertions.assertThat((long)actualProcessInstanceKey).withFailMessage("Incident was not raised in process instance %d but was raised in %s instead.%s", new Object[]{expectedProcessInstanceKey, actualProcessInstanceKey, this.composeIncidentDetails()})).isEqualTo(expectedProcessInstanceKey);
        return this;
    }

    public IncidentAssert occurredOnElement(String expectedElementId) {
        Assertions.assertThat((String)expectedElementId).isNotEmpty();
        IncidentRecordValue record = this.getIncidentCreatedRecordValue();
        String actualElementId = record.getElementId();
        ((AbstractStringAssert)Assertions.assertThat((String)actualElementId).withFailMessage("Error type was not raised on element '%s' but was raised on '%s' instead.%s", new Object[]{expectedElementId, actualElementId, this.composeIncidentDetails()})).isEqualTo(expectedElementId);
        return this;
    }

    public IncidentAssert occurredDuringJob(ActivatedJob expectedJob) {
        Assertions.assertThat((Object)expectedJob).isNotNull();
        return this.occurredDuringJob(expectedJob.getKey());
    }

    public IncidentAssert occurredDuringJob(long expectedJobKey) {
        IncidentRecordValue record = this.getIncidentCreatedRecordValue();
        long actualJobKey = record.getJobKey();
        ((AbstractLongAssert)Assertions.assertThat((long)actualJobKey).withFailMessage("Incident was not raised during job instance %d but was raised in %s instead.%s", new Object[]{expectedJobKey, actualJobKey, this.composeIncidentDetails()})).isEqualTo(expectedJobKey);
        return this;
    }

    public IncidentAssert isResolved() {
        boolean resolved = this.isIncidentResolved();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)resolved).withFailMessage("Incident is not resolved." + this.composeIncidentDetails(), new Object[0])).isTrue();
        return this;
    }

    public IncidentAssert isUnresolved() {
        boolean resolved = this.isIncidentResolved();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)resolved).withFailMessage("Incident is already resolved." + this.composeIncidentDetails(), new Object[0])).isFalse();
        return this;
    }

    private IncidentRecordStreamFilter getIncidentRecords(IncidentIntent intent) {
        return StreamFilter.incident((RecordStream)this.recordStream).withRejectionType(RejectionType.NULL_VAL).withIncidentKey(((Long)this.actual).longValue()).withIntent(intent);
    }

    private IncidentRecordValue getIncidentCreatedRecordValue() {
        Optional<Record<IncidentRecordValue>> optIncidentCreatedRecord = this.findIncidentCreatedRecord();
        ((OptionalAssert)Assertions.assertThat(optIncidentCreatedRecord).describedAs("Incident created record for key %d.%s", new Object[]{this.actual, this.composeIncidentDetails()})).isPresent();
        return (IncidentRecordValue)optIncidentCreatedRecord.get().getValue();
    }

    private Optional<Record<IncidentRecordValue>> findIncidentCreatedRecord() {
        return this.getIncidentRecords(IncidentIntent.CREATED).stream().findFirst();
    }

    private boolean isIncidentResolved() {
        return this.getIncidentRecords(IncidentIntent.RESOLVED).stream().findFirst().isPresent();
    }

    private String composeIncidentDetails() {
        long jobKey;
        Optional<Record<IncidentRecordValue>> optRecord = this.findIncidentCreatedRecord();
        if (!optRecord.isPresent()) {
            return this.LINE_SEPARATOR + "No incident details found for key " + this.actual;
        }
        Record<IncidentRecordValue> record = optRecord.get();
        StringBuilder result = new StringBuilder();
        result.append(this.LINE_SEPARATOR + "Incident[").append(this.LINE_SEPARATOR + "  key: ").append(record.getKey()).append(this.LINE_SEPARATOR + "  errorType: ").append(((IncidentRecordValue)record.getValue()).getErrorType()).append(this.LINE_SEPARATOR + "  errorMessage: \"").append(((IncidentRecordValue)record.getValue()).getErrorMessage()).append("\"");
        String elementId = ((IncidentRecordValue)record.getValue()).getElementId();
        if (elementId != null) {
            result.append(this.LINE_SEPARATOR + "  elementId: ").append(elementId);
        }
        if ((jobKey = ((IncidentRecordValue)record.getValue()).getJobKey()) != -1L) {
            result.append(this.LINE_SEPARATOR + "  jobKey: ").append(jobKey);
        }
        result.append(this.LINE_SEPARATOR + "]");
        return result.toString();
    }
}

