/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter.opensearch;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonAppend;
import io.camunda.zeebe.exporter.opensearch.OpensearchExporterException;
import io.camunda.zeebe.exporter.opensearch.RecordSequence;
import io.camunda.zeebe.exporter.opensearch.dto.BulkIndexAction;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.value.CommandDistributionRecordValue;
import io.camunda.zeebe.protocol.record.value.EvaluatedDecisionValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceCreationRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceResultRecordValue;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import io.camunda.zeebe.util.SemanticVersion;
import io.camunda.zeebe.util.VersionUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.entity.ContentProducer;

final class BulkIndexRequest
implements ContentProducer {
    private static final ObjectMapper MAPPER = new ObjectMapper().addMixIn(Record.class, RecordSequenceMixin.class).addMixIn(EvaluatedDecisionValue.class, EvaluatedDecisionMixin.class).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
    private static final ObjectMapper PREVIOUS_VERSION_MAPPER = new ObjectMapper().addMixIn(EvaluatedDecisionValue.class, EvaluatedDecisionMixin.class).addMixIn(Record.class, RecordMetadata87Mixin.class).addMixIn(ProcessInstanceCreationRecordValue.class, ProcessInstanceCreation87Mixin.class).addMixIn(ProcessInstanceRecordValue.class, ProcessInstance87Mixin.class).addMixIn(ProcessInstanceResultRecordValue.class, ProcessInstanceResult87Mixin.class).addMixIn(UserTaskRecordValue.class, UserTask87Mixin.class).addMixIn(JobRecordValue.class, Job87Mixin.class).addMixIn(CommandDistributionRecordValue.class, CommandDistribution87Mixin.class).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
    private static final String RECORD_SEQUENCE_PROPERTY = "sequence";
    private static final String RECORD_AUTHORIZATIONS_PROPERTY = "authorizations";
    private static final String RECORD_DECISION_EVALUATION_INSTANCE_KEY_PROPERTY = "decisionEvaluationInstanceKey";
    private static final String BATCH_OPERATION_REFERENCE_PROPERTY = "batchOperationReference";
    private static final String TAGS_PROPERTY = "tags";
    private static final String RESULT_PROPERTY = "result";
    private static final String DENIED_REASON_PROPERTY = "deniedReason";
    private static final String RUNTIME_INSTRUCTIONS_PROPERTY = "runtimeInstructions";
    private static final String ELEMENT_INSTANCE_PATH_PROPERTY = "elementInstancePath";
    private static final String PROCESS_DEFINITION_PATH_PROPERTY = "processDefinitionPath";
    private static final String CALLING_ELEMENT_PATH_PROPERTY = "callingElementPath";
    private static final String AUTH_INFO_PROPERTY = "authInfo";
    private final List<BulkOperation> operations = new ArrayList<BulkOperation>();
    private BulkIndexAction lastIndexedMetadata;
    private int memoryUsageBytes = 0;

    BulkIndexRequest() {
    }

    boolean index(BulkIndexAction action, Record<?> record, RecordSequence recordSequence) {
        byte[] source;
        if (this.lastIndexedMetadata != null && this.lastIndexedMetadata.equals(action)) {
            return false;
        }
        try {
            source = BulkIndexRequest.serializeRecord(record, recordSequence);
        }
        catch (IOException e) {
            throw new OpensearchExporterException(String.format("Failed to serialize record to JSON for indexing action %s", action), e);
        }
        BulkOperation command = new BulkOperation(action, source);
        this.memoryUsageBytes += command.source().length;
        this.lastIndexedMetadata = action;
        this.operations.add(command);
        return true;
    }

    private static byte[] serializeRecord(Record<?> record, RecordSequence recordSequence) throws IOException {
        ObjectMapper mapper = BulkIndexRequest.isPreviousVersionRecord(record.getBrokerVersion()) ? PREVIOUS_VERSION_MAPPER : MAPPER;
        return mapper.writer().withAttribute((Object)RECORD_SEQUENCE_PROPERTY, (Object)recordSequence.sequence()).writeValueAsBytes(record);
    }

    int size() {
        return this.operations.size();
    }

    int memoryUsageBytes() {
        return this.memoryUsageBytes;
    }

    boolean isEmpty() {
        return this.operations.isEmpty();
    }

    void clear() {
        this.operations.clear();
        this.memoryUsageBytes = 0;
        this.lastIndexedMetadata = null;
    }

    BulkIndexAction lastIndexedMetadata() {
        return this.lastIndexedMetadata;
    }

    List<BulkOperation> bulkOperations() {
        return Collections.unmodifiableList(this.operations);
    }

    public void writeTo(OutputStream outStream) throws IOException {
        for (BulkOperation operation : this.operations) {
            MAPPER.writeValue(outStream, (Object)operation.metadata());
            outStream.write(10);
            outStream.write(operation.source());
            outStream.write(10);
        }
    }

    private static boolean isPreviousVersionRecord(String brokerVersion) {
        SemanticVersion semanticVersion = (SemanticVersion)SemanticVersion.parse((String)brokerVersion).orElseThrow(() -> new IllegalArgumentException("Expected to parse valid semantic version, but got [%s]".formatted(brokerVersion)));
        int currentMinorVersion = VersionUtil.getSemanticVersion().map(SemanticVersion::minor).orElseThrow(() -> new IllegalStateException("Expected to have a valid semantic version"));
        return semanticVersion.minor() < currentMinorVersion;
    }

    record BulkOperation(BulkIndexAction metadata, byte[] source) {
    }

    @JsonAppend(attrs={@JsonAppend.Attr(value="sequence")})
    @JsonIgnoreProperties(value={"authorizations"})
    private static final class RecordSequenceMixin {
        private RecordSequenceMixin() {
        }
    }

    @JsonIgnoreProperties(value={"decisionEvaluationInstanceKey"})
    private static final class EvaluatedDecisionMixin {
        private EvaluatedDecisionMixin() {
        }
    }

    @JsonAppend(attrs={@JsonAppend.Attr(value="sequence")})
    @JsonIgnoreProperties(value={"batchOperationReference", "authorizations"})
    private static final class RecordMetadata87Mixin {
        private RecordMetadata87Mixin() {
        }
    }

    @JsonIgnoreProperties(value={"tags", "runtimeInstructions"})
    private static final class ProcessInstanceCreation87Mixin {
        private ProcessInstanceCreation87Mixin() {
        }
    }

    @JsonIgnoreProperties(value={"tags", "elementInstancePath", "processDefinitionPath", "callingElementPath"})
    private static final class ProcessInstance87Mixin {
        private ProcessInstance87Mixin() {
        }
    }

    @JsonIgnoreProperties(value={"tags"})
    private static final class ProcessInstanceResult87Mixin {
        private ProcessInstanceResult87Mixin() {
        }
    }

    @JsonIgnoreProperties(value={"deniedReason"})
    private static final class UserTask87Mixin {
        private UserTask87Mixin() {
        }
    }

    @JsonIgnoreProperties(value={"result", "tags"})
    private static final class Job87Mixin {
        private Job87Mixin() {
        }
    }

    @JsonIgnoreProperties(value={"authInfo"})
    private static final class CommandDistribution87Mixin {
        private CommandDistribution87Mixin() {
        }
    }
}

