/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter.opensearch;

import io.camunda.zeebe.exporter.opensearch.OpensearchExporterConfiguration;
import io.github.acm19.aws.interceptor.http.AwsRequestSigningApacheInterceptor;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;

final class RestClientFactory {
    private static final RestClientFactory INSTANCE = new RestClientFactory();
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getPackageName());

    private RestClientFactory() {
    }

    static RestClient of(OpensearchExporterConfiguration config, HttpRequestInterceptor ... interceptors) {
        return RestClientFactory.of(config, false, interceptors);
    }

    static RestClient of(OpensearchExporterConfiguration config, boolean allowAllSelfSignedCertificates, HttpRequestInterceptor ... interceptors) {
        return INSTANCE.createRestClient(config, allowAllSelfSignedCertificates, interceptors);
    }

    private RestClient createRestClient(OpensearchExporterConfiguration config, boolean allowAllSelfSignedCertificates, HttpRequestInterceptor ... interceptors) {
        HttpHost[] httpHosts = this.parseUrl(config);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts).setRequestConfigCallback(b -> b.setConnectTimeout(config.requestTimeoutMs).setSocketTimeout(config.requestTimeoutMs)).setHttpClientConfigCallback(b -> this.configureHttpClient(config, b, allowAllSelfSignedCertificates, interceptors));
        return builder.build();
    }

    private HttpAsyncClientBuilder configureHttpClient(OpensearchExporterConfiguration config, HttpAsyncClientBuilder builder, boolean allowAllSelfSignedCertificates, HttpRequestInterceptor ... interceptors) {
        builder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(1).build());
        if (config.hasAuthenticationPresent()) {
            this.setupBasicAuthentication(config, builder);
            this.log.info("Basic authentication is enabled.");
        } else {
            this.log.info("Basic authentication is disabled.");
        }
        if (config.aws.enabled) {
            this.configureAws(builder, config.aws);
            this.log.info("AWS Signing is enabled.");
        } else {
            this.log.info("AWS Signing is disabled.");
        }
        this.log.trace("Attempt to load interceptor plugins");
        for (HttpRequestInterceptor interceptor : interceptors) {
            builder.addInterceptorLast(interceptor);
        }
        if (allowAllSelfSignedCertificates) {
            try {
                SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build();
                builder.setSSLContext(sslContext);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return builder;
    }

    private void setupBasicAuthentication(OpensearchExporterConfiguration config, HttpAsyncClientBuilder builder) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(config.getAuthentication().getUsername(), config.getAuthentication().getPassword()));
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    public void configureAws(HttpAsyncClientBuilder builder, OpensearchExporterConfiguration.AwsConfiguration awsConfiguration) {
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.builder().build();
        credentialsProvider.resolveCredentials();
        AwsV4HttpSigner signer = AwsV4HttpSigner.create();
        AwsRequestSigningApacheInterceptor signInterceptor = new AwsRequestSigningApacheInterceptor(awsConfiguration.serviceName, (HttpSigner)signer, (AwsCredentialsProvider)credentialsProvider, awsConfiguration.region);
        builder.addInterceptorLast((HttpRequestInterceptor)signInterceptor);
    }

    private HttpHost[] parseUrl(OpensearchExporterConfiguration config) {
        String[] urls = config.url.split(",");
        HttpHost[] hosts = new HttpHost[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            hosts[i] = HttpHost.create((String)urls[i]);
        }
        return hosts;
    }
}

