/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter.opensearch;

import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.camunda.zeebe.util.micrometer.StatefulGauge;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;

public class OpensearchMetrics {
    private static final String NAMESPACE = "zeebe.opensearch.exporter";
    private final MeterRegistry meterRegistry;
    private final StatefulGauge bulkMemorySize;
    private final Timer flushDuration;
    private final DistributionSummary bulkSize;
    private final Counter failedFlush;

    public OpensearchMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        this.bulkMemorySize = StatefulGauge.builder((String)this.meterName("bulk.memory.size")).description("Exporter bulk memory size").register(meterRegistry);
        this.flushDuration = Timer.builder((String)this.meterName("flush.duration.seconds")).description("Flush duration of bulk exporters in seconds").publishPercentileHistogram().minimumExpectedValue(Duration.ofMillis(10L)).register(meterRegistry);
        this.bulkSize = DistributionSummary.builder((String)this.meterName("bulk.size")).description("Exporter bulk size").serviceLevelObjectives(new double[]{10.0, 100.0, 1000.0, 10000.0, 100000.0}).register(meterRegistry);
        this.failedFlush = Counter.builder((String)this.meterName("failed.flush")).description("Number of failed flush operations").register(meterRegistry);
    }

    public CloseableSilently measureFlushDuration() {
        return MicrometerUtil.timer((Timer)this.flushDuration, (Timer.Sample)Timer.start((MeterRegistry)this.meterRegistry));
    }

    public void recordBulkSize(int bulkSize) {
        this.bulkSize.record((double)bulkSize);
    }

    public void recordBulkMemorySize(int bulkMemorySize) {
        this.bulkMemorySize.set((long)bulkMemorySize);
    }

    public void recordFailedFlush() {
        this.failedFlush.increment();
    }

    private String meterName(String name) {
        return "zeebe.opensearch.exporter." + name;
    }
}

