/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter.opensearch;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonAppend;
import io.camunda.zeebe.exporter.opensearch.OpensearchExporterException;
import io.camunda.zeebe.exporter.opensearch.RecordSequence;
import io.camunda.zeebe.exporter.opensearch.dto.BulkIndexAction;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.util.SemanticVersion;
import io.camunda.zeebe.util.VersionUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.entity.ContentProducer;

final class BulkIndexRequest
implements ContentProducer {
    private static final ObjectMapper MAPPER = new ObjectMapper().addMixIn(Record.class, RecordSequenceMixin.class).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
    private static final ObjectMapper PREVIOUS_VERSION_MAPPER = new ObjectMapper().addMixIn(Record.class, RecordSequenceMixin.class).addMixIn(DeploymentRecordValue.class, Deployment86Mixin.class).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
    private static final String RECORD_SEQUENCE_PROPERTY = "sequence";
    private static final String RESOURCE_METADATA_PROPERTY = "resourceMetadata";
    private final List<BulkOperation> operations = new ArrayList<BulkOperation>();
    private BulkIndexAction lastIndexedMetadata;
    private int memoryUsageBytes = 0;

    BulkIndexRequest() {
    }

    boolean index(BulkIndexAction action, Record<?> record, RecordSequence recordSequence) {
        byte[] source;
        if (this.lastIndexedMetadata != null && this.lastIndexedMetadata.equals(action)) {
            return false;
        }
        try {
            source = BulkIndexRequest.serializeRecord(record, recordSequence);
        }
        catch (IOException e) {
            throw new OpensearchExporterException(String.format("Failed to serialize record to JSON for indexing action %s", action), e);
        }
        BulkOperation command = new BulkOperation(action, source);
        this.memoryUsageBytes += command.source().length;
        this.lastIndexedMetadata = action;
        this.operations.add(command);
        return true;
    }

    private static byte[] serializeRecord(Record<?> record, RecordSequence recordSequence) throws IOException {
        ObjectMapper mapper = BulkIndexRequest.isPreviousVersionRecord(record.getBrokerVersion()) ? PREVIOUS_VERSION_MAPPER : MAPPER;
        return mapper.writer().withAttribute((Object)RECORD_SEQUENCE_PROPERTY, (Object)recordSequence.sequence()).writeValueAsBytes(record);
    }

    int size() {
        return this.operations.size();
    }

    int memoryUsageBytes() {
        return this.memoryUsageBytes;
    }

    boolean isEmpty() {
        return this.operations.isEmpty();
    }

    void clear() {
        this.operations.clear();
        this.memoryUsageBytes = 0;
        this.lastIndexedMetadata = null;
    }

    BulkIndexAction lastIndexedMetadata() {
        return this.lastIndexedMetadata;
    }

    List<BulkOperation> bulkOperations() {
        return Collections.unmodifiableList(this.operations);
    }

    public void writeTo(OutputStream outStream) throws IOException {
        for (BulkOperation operation : this.operations) {
            MAPPER.writeValue(outStream, (Object)operation.metadata());
            outStream.write(10);
            outStream.write(operation.source());
            outStream.write(10);
        }
    }

    private static boolean isPreviousVersionRecord(String brokerVersion) {
        SemanticVersion semanticVersion = (SemanticVersion)SemanticVersion.parse((String)brokerVersion).orElseThrow(() -> new IllegalArgumentException("Expected to parse valid semantic version, but got [%s]".formatted(brokerVersion)));
        int currentMinorVersion = VersionUtil.getSemanticVersion().map(SemanticVersion::minor).orElseThrow(() -> new IllegalStateException("Expected to have a valid semantic version"));
        return semanticVersion.minor() < currentMinorVersion;
    }

    record BulkOperation(BulkIndexAction metadata, byte[] source) {
    }

    @JsonAppend(attrs={@JsonAppend.Attr(value="sequence")})
    private static final class RecordSequenceMixin {
        private RecordSequenceMixin() {
        }
    }

    @JsonIgnoreProperties(value={"resourceMetadata"})
    private static final class Deployment86Mixin {
        private Deployment86Mixin() {
        }
    }
}

