/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter.opensearch.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public record Template(@JsonProperty(value="index_patterns") List<String> patterns, @JsonProperty(value="composed_of") List<String> composedOf, TemplateProperty template, Long priority, Long version) {

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public record TemplateProperty(Map<String, Object> aliases, Map<String, Object> settings, Map<String, Object> mappings) {
        public static TemplateProperty mutableCopyOf(TemplateProperty templateProperty) {
            if (templateProperty == null) {
                return new TemplateProperty(new HashMap<String, Object>(), new HashMap<String, Object>(), new HashMap<String, Object>());
            }
            return new TemplateProperty(Optional.ofNullable(templateProperty.aliases).map(HashMap::new).orElseGet(HashMap::new), Optional.ofNullable(templateProperty.settings).map(HashMap::new).orElseGet(HashMap::new), Optional.ofNullable(templateProperty.mappings).map(HashMap::new).orElseGet(HashMap::new));
        }
    }

    public static final class MutableCopyBuilder {
        private List<String> patterns;
        private List<String> composedOf;
        private TemplateProperty template;
        private Long priority;
        private Long version;

        private MutableCopyBuilder() {
        }

        public static MutableCopyBuilder copyOf(Template template) {
            MutableCopyBuilder builder = new MutableCopyBuilder();
            builder.patterns = Optional.ofNullable(template.patterns).map(ArrayList::new).orElseGet(ArrayList::new);
            builder.composedOf = Optional.ofNullable(template.composedOf).map(ArrayList::new).orElseGet(ArrayList::new);
            builder.template = TemplateProperty.mutableCopyOf(template.template);
            builder.priority = template.priority;
            builder.version = template.version;
            return builder;
        }

        public MutableCopyBuilder updatePatterns(Consumer<List<String>> patternsConsumer) {
            patternsConsumer.accept(this.patterns);
            return this;
        }

        public MutableCopyBuilder updateComposedOf(Consumer<List<String>> composedOfConsumer) {
            composedOfConsumer.accept(this.composedOf);
            return this;
        }

        public MutableCopyBuilder updateAliases(Consumer<Map<String, Object>> aliasesConsumer) {
            aliasesConsumer.accept(this.template.aliases);
            return this;
        }

        public MutableCopyBuilder withPriority(Long priority) {
            this.priority = priority;
            return this;
        }

        public Template build() {
            return new Template(this.patterns, this.composedOf, this.template, this.priority, this.version);
        }
    }
}

