/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter.opensearch;

import io.camunda.search.connect.plugin.PluginConfiguration;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import java.util.ArrayList;
import java.util.List;

public class OpensearchExporterConfiguration {
    private static final String DEFAULT_URL = "http://localhost:9200";
    public String url = "http://localhost:9200";
    public int requestTimeoutMs = 30000;
    public final IndexConfiguration index = new IndexConfiguration();
    public final BulkConfiguration bulk = new BulkConfiguration();
    public final AwsConfiguration aws = new AwsConfiguration();
    public final RetentionConfiguration retention = new RetentionConfiguration();
    public final List<PluginConfiguration> interceptorPlugins = new ArrayList<PluginConfiguration>();
    private final AuthenticationConfiguration authentication = new AuthenticationConfiguration();

    public boolean hasAuthenticationPresent() {
        return this.getAuthentication().isPresent();
    }

    public AuthenticationConfiguration getAuthentication() {
        return this.authentication;
    }

    public List<PluginConfiguration> getInterceptorPlugins() {
        return this.interceptorPlugins;
    }

    public String toString() {
        return "OpensearchExporterConfiguration{url='" + this.url + "', index=" + String.valueOf(this.index) + ", bulk=" + String.valueOf(this.bulk) + ", aws=" + String.valueOf(this.aws) + ", retention=" + String.valueOf(this.retention) + ", interceptorPlugins=" + String.valueOf(this.interceptorPlugins) + "}";
    }

    public boolean shouldIndexRecord(Record<?> record) {
        return this.shouldIndexRecordType(record.getRecordType()) && this.shouldIndexValueType(record.getValueType());
    }

    public boolean shouldIndexValueType(ValueType valueType) {
        switch (valueType) {
            case DEPLOYMENT: {
                return this.index.deployment;
            }
            case PROCESS: {
                return this.index.process;
            }
            case ERROR: {
                return this.index.error;
            }
            case INCIDENT: {
                return this.index.incident;
            }
            case JOB: {
                return this.index.job;
            }
            case JOB_BATCH: {
                return this.index.jobBatch;
            }
            case MESSAGE: {
                return this.index.message;
            }
            case MESSAGE_BATCH: {
                return this.index.messageBatch;
            }
            case MESSAGE_SUBSCRIPTION: {
                return this.index.messageSubscription;
            }
            case VARIABLE: {
                return this.index.variable;
            }
            case VARIABLE_DOCUMENT: {
                return this.index.variableDocument;
            }
            case PROCESS_INSTANCE: {
                return this.index.processInstance;
            }
            case PROCESS_INSTANCE_BATCH: {
                return this.index.processInstanceBatch;
            }
            case PROCESS_INSTANCE_CREATION: {
                return this.index.processInstanceCreation;
            }
            case PROCESS_INSTANCE_MIGRATION: {
                return this.index.processInstanceMigration;
            }
            case PROCESS_INSTANCE_MODIFICATION: {
                return this.index.processInstanceModification;
            }
            case PROCESS_MESSAGE_SUBSCRIPTION: {
                return this.index.processMessageSubscription;
            }
            case DECISION_REQUIREMENTS: {
                return this.index.decisionRequirements;
            }
            case DECISION: {
                return this.index.decision;
            }
            case DECISION_EVALUATION: {
                return this.index.decisionEvaluation;
            }
            case CHECKPOINT: {
                return this.index.checkpoint;
            }
            case TIMER: {
                return this.index.timer;
            }
            case MESSAGE_START_EVENT_SUBSCRIPTION: {
                return this.index.messageStartEventSubscription;
            }
            case PROCESS_EVENT: {
                return this.index.processEvent;
            }
            case DEPLOYMENT_DISTRIBUTION: {
                return this.index.deploymentDistribution;
            }
            case ESCALATION: {
                return this.index.escalation;
            }
            case SIGNAL: {
                return this.index.signal;
            }
            case SIGNAL_SUBSCRIPTION: {
                return this.index.signalSubscription;
            }
            case RESOURCE_DELETION: {
                return this.index.resourceDeletion;
            }
            case COMMAND_DISTRIBUTION: {
                return this.index.commandDistribution;
            }
            case FORM: {
                return this.index.form;
            }
            case USER_TASK: {
                return this.index.userTask;
            }
            case COMPENSATION_SUBSCRIPTION: {
                return this.index.compensationSubscription;
            }
            case MESSAGE_CORRELATION: {
                return this.index.messageCorrelation;
            }
            case USER: {
                return this.index.user;
            }
            case AUTHORIZATION: {
                return this.index.authorization;
            }
        }
        return false;
    }

    public boolean shouldIndexRecordType(RecordType recordType) {
        switch (recordType) {
            case EVENT: {
                return this.index.event;
            }
            case COMMAND: {
                return this.index.command;
            }
            case COMMAND_REJECTION: {
                return this.index.rejection;
            }
        }
        return false;
    }

    public static class IndexConfiguration {
        public static final int DEFAULT_INDEX_TEMPLATE_PRIORITY = 20;
        public String prefix = "zeebe-record";
        public boolean createTemplate = true;
        public boolean command = false;
        public boolean event = true;
        public boolean rejection = false;
        public boolean decision = true;
        public boolean decisionEvaluation = true;
        public boolean decisionRequirements = true;
        public boolean deployment = true;
        public boolean error = true;
        public boolean incident = true;
        public boolean job = true;
        public boolean jobBatch = false;
        public boolean message = true;
        public boolean messageBatch = false;
        public boolean messageSubscription = true;
        public boolean process = true;
        public boolean processInstance = true;
        public boolean processInstanceBatch = false;
        public boolean processInstanceCreation = true;
        public boolean processInstanceMigration = true;
        public boolean processInstanceModification = true;
        public boolean processMessageSubscription = true;
        public boolean variable = true;
        public boolean variableDocument = true;
        public boolean checkpoint = false;
        public boolean timer = true;
        public boolean messageStartEventSubscription = true;
        public boolean processEvent = false;
        public boolean deploymentDistribution = true;
        public boolean escalation = true;
        public boolean signal = true;
        public boolean signalSubscription = true;
        public boolean resourceDeletion = true;
        public boolean commandDistribution = true;
        public boolean form = true;
        public boolean userTask = true;
        public boolean compensationSubscription = true;
        public boolean messageCorrelation = true;
        public boolean user = true;
        public boolean authorization = true;
        private Integer numberOfShards = null;
        private Integer numberOfReplicas = null;
        private int priority = 20;

        public Integer getNumberOfShards() {
            return this.numberOfShards;
        }

        public void setNumberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
        }

        public Integer getNumberOfReplicas() {
            return this.numberOfReplicas;
        }

        public void setNumberOfReplicas(Integer numberOfReplicas) {
            this.numberOfReplicas = numberOfReplicas;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public String toString() {
            return "IndexConfiguration{indexPrefix='" + this.prefix + "', createTemplate=" + this.createTemplate + ", command=" + this.command + ", event=" + this.event + ", rejection=" + this.rejection + ", error=" + this.error + ", deployment=" + this.deployment + ", process=" + this.process + ", incident=" + this.incident + ", job=" + this.job + ", message=" + this.message + ", messageBatch=" + this.messageBatch + ", messageSubscription=" + this.messageSubscription + ", variable=" + this.variable + ", variableDocument=" + this.variableDocument + ", processInstance=" + this.processInstanceBatch + ", processInstanceBatch=" + this.processInstance + ", processInstanceCreation=" + this.processInstanceCreation + ", processInstanceMigration=" + this.processInstanceMigration + ", processInstanceModification=" + this.processInstanceModification + ", processMessageSubscription=" + this.processMessageSubscription + ", decisionRequirements=" + this.decisionRequirements + ", decision=" + this.decision + ", decisionEvaluation=" + this.decisionEvaluation + ", checkpoint=" + this.checkpoint + ", timer=" + this.timer + ", messageStartEventSubscription=" + this.messageStartEventSubscription + ", processEvent=" + this.processEvent + ", deploymentDistribution=" + this.deploymentDistribution + ", escalation=" + this.escalation + ", signal=" + this.signal + ", signalSubscription=" + this.signalSubscription + ", resourceDeletion=" + this.resourceDeletion + ", recordDistribution=" + this.commandDistribution + ", form=" + this.form + ", userTask=" + this.userTask + ", compensationSubscription=" + this.compensationSubscription + ", messageCorrelation=" + this.messageCorrelation + ", user=" + this.user + ", authorization=" + this.authorization + "}";
        }
    }

    public static class BulkConfiguration {
        public int delay = 5;
        public int size = 1000;
        public int memoryLimit = 0xA00000;

        public String toString() {
            return "BulkConfiguration{delay=" + this.delay + ", size=" + this.size + ", memoryLimit=" + this.memoryLimit + "}";
        }
    }

    public static class AwsConfiguration {
        private static final String AWS_REGION_ENV_VARIABLE = "AWS_REGION";
        private static final String AWS_OPENSEARCH_SERVICE_NAME = "es";
        public boolean enabled = false;
        public String serviceName = "es";
        public String region = System.getenv("AWS_REGION");

        public String toString() {
            if (this.enabled) {
                return "AwsConfiguration{serviceName=" + this.serviceName + ", region=" + this.region + "}";
            }
            return "AwsConfiguration{Disabled}";
        }
    }

    public static class RetentionConfiguration {
        private boolean enabled = false;
        private String minimumAge = "30d";
        private String policyName = "zeebe-record-retention-policy";
        private String policyDescription = "Zeebe record retention policy";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getMinimumAge() {
            return this.minimumAge;
        }

        public void setMinimumAge(String minimumAge) {
            this.minimumAge = minimumAge;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public String getPolicyDescription() {
            return this.policyDescription;
        }

        public void setPolicyDescription(String policyDescription) {
            this.policyDescription = policyDescription;
        }

        public String toString() {
            return "RetentionConfiguration{isEnabled=" + this.enabled + ", minimumAge='" + this.minimumAge + ", policyName='" + this.policyName + ", policyDescription='" + this.policyDescription + "'}";
        }
    }

    public static class AuthenticationConfiguration {
        private String username;
        private String password;

        public boolean isPresent() {
            return this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty();
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String toString() {
            return "AuthenticationConfiguration{Confidential information}";
        }
    }
}

