/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter.opensearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.exporter.opensearch.BulkIndexRequest;
import io.camunda.zeebe.exporter.opensearch.OpensearchExporterConfiguration;
import io.camunda.zeebe.exporter.opensearch.OpensearchExporterException;
import io.camunda.zeebe.exporter.opensearch.OpensearchMetrics;
import io.camunda.zeebe.exporter.opensearch.RecordIndexRouter;
import io.camunda.zeebe.exporter.opensearch.RecordSequence;
import io.camunda.zeebe.exporter.opensearch.RestClientFactory;
import io.camunda.zeebe.exporter.opensearch.TemplateReader;
import io.camunda.zeebe.exporter.opensearch.dto.AddPolicyRequest;
import io.camunda.zeebe.exporter.opensearch.dto.BulkIndexAction;
import io.camunda.zeebe.exporter.opensearch.dto.BulkIndexResponse;
import io.camunda.zeebe.exporter.opensearch.dto.DeleteStateManagementPolicyResponse;
import io.camunda.zeebe.exporter.opensearch.dto.GetIndexStateManagementPolicyResponse;
import io.camunda.zeebe.exporter.opensearch.dto.IndexPolicyResponse;
import io.camunda.zeebe.exporter.opensearch.dto.PutIndexStateManagementPolicyRequest;
import io.camunda.zeebe.exporter.opensearch.dto.PutIndexStateManagementPolicyResponse;
import io.camunda.zeebe.exporter.opensearch.dto.PutIndexTemplateResponse;
import io.camunda.zeebe.exporter.opensearch.dto.Template;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.VersionUtil;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.opensearch.client.Request;
import org.opensearch.client.Response;
import org.opensearch.client.RestClient;

public class OpensearchClient
implements AutoCloseable {
    public static final String ISM_INITIAL_STATE = "initial";
    public static final String ISM_DELETE_STATE = "delete";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final RestClient client;
    private final OpensearchExporterConfiguration configuration;
    private final TemplateReader templateReader;
    private final RecordIndexRouter indexRouter;
    private final BulkIndexRequest bulkIndexRequest;
    private final OpensearchMetrics metrics;

    OpensearchClient(OpensearchExporterConfiguration configuration, MeterRegistry meterRegistry) {
        this(configuration, new BulkIndexRequest(), RestClientFactory.of(configuration, new HttpRequestInterceptor[0]), new RecordIndexRouter(configuration.index), new TemplateReader(configuration.index), new OpensearchMetrics(meterRegistry));
    }

    OpensearchClient(OpensearchExporterConfiguration configuration, MeterRegistry meterRegistry, RestClient restClient) {
        this(configuration, new BulkIndexRequest(), restClient, new RecordIndexRouter(configuration.index), new TemplateReader(configuration.index), new OpensearchMetrics(meterRegistry));
    }

    OpensearchClient(OpensearchExporterConfiguration configuration, BulkIndexRequest bulkIndexRequest, RestClient client, RecordIndexRouter indexRouter, TemplateReader templateReader, OpensearchMetrics metrics) {
        this.configuration = configuration;
        this.bulkIndexRequest = bulkIndexRequest;
        this.client = client;
        this.indexRouter = indexRouter;
        this.templateReader = templateReader;
        this.metrics = metrics;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public boolean index(Record<?> record, RecordSequence recordSequence) {
        BulkIndexAction action = new BulkIndexAction(this.indexRouter.indexFor(record), this.indexRouter.idFor(record), this.indexRouter.routingFor(record));
        return this.bulkIndexRequest.index(action, record, recordSequence);
    }

    public void flush() {
        if (this.bulkIndexRequest.isEmpty()) {
            return;
        }
        this.metrics.recordBulkSize(this.bulkIndexRequest.size());
        this.metrics.recordBulkMemorySize(this.bulkIndexRequest.memoryUsageBytes());
        try (CloseableSilently ignored = this.metrics.measureFlushDuration();){
            this.exportBulk();
            this.bulkIndexRequest.clear();
        }
        catch (OpensearchExporterException e) {
            this.metrics.recordFailedFlush();
            throw e;
        }
    }

    public boolean shouldFlush() {
        return this.bulkIndexRequest.memoryUsageBytes() >= this.configuration.bulk.memoryLimit || this.bulkIndexRequest.size() >= this.configuration.bulk.size;
    }

    public boolean putIndexTemplate(ValueType valueType) {
        return this.putIndexTemplate(valueType, VersionUtil.getVersionLowerCase());
    }

    public boolean putIndexTemplate(ValueType valueType, String version) {
        String templateName = this.indexRouter.indexPrefixForValueType(valueType, version);
        Template template = this.templateReader.readIndexTemplate(valueType, this.indexRouter.searchPatternForValueType(valueType, version), this.indexRouter.aliasNameForValueType(valueType));
        return this.putIndexTemplate(templateName, template);
    }

    public boolean putComponentTemplate() {
        Template template = this.templateReader.readComponentTemplate();
        return this.putComponentTemplate(template);
    }

    private void exportBulk() {
        BulkIndexResponse response;
        try {
            Request request = new Request("POST", "/_bulk");
            EntityTemplate body = new EntityTemplate((ContentProducer)this.bulkIndexRequest);
            request.setJsonEntity(new String(body.getContent().readAllBytes()));
            response = this.sendRequest(request, BulkIndexResponse.class);
        }
        catch (IOException e) {
            throw new OpensearchExporterException("Failed to flush bulk", e);
        }
        if (response.errors()) {
            this.throwCollectedBulkError(response);
        }
    }

    private void throwCollectedBulkError(BulkIndexResponse bulkResponse) {
        ArrayList collectedErrors = new ArrayList();
        bulkResponse.items().stream().flatMap(item -> Optional.ofNullable(item.index()).stream()).flatMap(index -> Optional.ofNullable(index.error()).stream()).collect(Collectors.groupingBy(BulkIndexResponse.Error::type)).forEach((errorType, errors) -> collectedErrors.add(String.format("Failed to flush %d item(s) of bulk request [type: %s, reason: %s]", errors.size(), errorType, ((BulkIndexResponse.Error)errors.get(0)).reason())));
        throw new OpensearchExporterException("Failed to flush bulk request: " + String.valueOf(collectedErrors));
    }

    private boolean putIndexTemplate(String templateName, Template template) {
        try {
            Request request = new Request("PUT", "/_index_template/" + templateName);
            request.setJsonEntity(MAPPER.writeValueAsString((Object)template));
            PutIndexTemplateResponse response = this.sendRequest(request, PutIndexTemplateResponse.class);
            return response.acknowledged();
        }
        catch (IOException e) {
            throw new OpensearchExporterException("Failed to put index template", e);
        }
    }

    private boolean putComponentTemplate(Template template) {
        try {
            Request request = new Request("PUT", "/_component_template/" + this.configuration.index.prefix + "-" + VersionUtil.getVersionLowerCase());
            request.setJsonEntity(MAPPER.writeValueAsString((Object)template));
            PutIndexTemplateResponse response = this.sendRequest(request, PutIndexTemplateResponse.class);
            return response.acknowledged();
        }
        catch (IOException e) {
            throw new OpensearchExporterException("Failed to put component template", e);
        }
    }

    Optional<GetIndexStateManagementPolicyResponse> getIndexStateManagementPolicy() {
        try {
            Request request = new Request("GET", "/_plugins/_ism/policies/" + this.configuration.retention.getPolicyName());
            return Optional.of(this.sendRequest(request, GetIndexStateManagementPolicyResponse.class));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public boolean createIndexStateManagementPolicy() {
        return this.putIndexStateManagementPolicy(Collections.emptyMap());
    }

    public boolean updateIndexStateManagementPolicy(Integer seqNo, Integer primaryTerm) {
        Map<String, String> queryParameters = Map.of("if_seq_no", seqNo.toString(), "if_primary_term", primaryTerm.toString());
        return this.putIndexStateManagementPolicy(queryParameters);
    }

    public boolean deleteIndexStateManagementPolicy() {
        try {
            Request request = new Request("DELETE", "/_plugins/_ism/policies/" + this.configuration.retention.getPolicyName());
            DeleteStateManagementPolicyResponse response = this.sendRequest(request, DeleteStateManagementPolicyResponse.class);
            return response.result().equals("deleted");
        }
        catch (IOException e) {
            throw new OpensearchExporterException("Failed to delete index state management policy", e);
        }
    }

    private boolean putIndexStateManagementPolicy(Map<String, String> queryParameters) {
        try {
            Request request = new Request("PUT", "/_plugins/_ism/policies/" + this.configuration.retention.getPolicyName());
            queryParameters.forEach((arg_0, arg_1) -> ((Request)request).addParameter(arg_0, arg_1));
            PutIndexStateManagementPolicyRequest requestEntity = this.createPutIndexManagementPolicyRequest();
            request.setJsonEntity(MAPPER.writeValueAsString((Object)requestEntity));
            PutIndexStateManagementPolicyResponse response = this.sendRequest(request, PutIndexStateManagementPolicyResponse.class);
            return response.policy() != null;
        }
        catch (IOException e) {
            throw new OpensearchExporterException("Failed to put index state management policy", e);
        }
    }

    public boolean bulkAddISMPolicyToAllZeebeIndices() {
        try {
            Request request = new Request("POST", "/_plugins/_ism/add/" + this.configuration.index.prefix + "*");
            AddPolicyRequest requestEntity = new AddPolicyRequest(this.configuration.retention.getPolicyName());
            request.setJsonEntity(MAPPER.writeValueAsString((Object)requestEntity));
            IndexPolicyResponse response = this.sendRequest(request, IndexPolicyResponse.class);
            return !response.failures();
        }
        catch (IOException e) {
            throw new OpensearchExporterException("Failed to add policy to indices", e);
        }
    }

    public boolean bulkRemoveISMPolicyToAllZeebeIndices() {
        try {
            Request request = new Request("POST", "/_plugins/_ism/remove/" + this.configuration.index.prefix + "*");
            IndexPolicyResponse response = this.sendRequest(request, IndexPolicyResponse.class);
            return !response.failures();
        }
        catch (IOException e) {
            throw new OpensearchExporterException("Failed to remove policy from indices", e);
        }
    }

    private PutIndexStateManagementPolicyRequest createPutIndexManagementPolicyRequest() {
        PutIndexStateManagementPolicyRequest.Policy.State initialState = new PutIndexStateManagementPolicyRequest.Policy.State(ISM_INITIAL_STATE, Collections.emptyList(), List.of(new PutIndexStateManagementPolicyRequest.Policy.State.Transition(ISM_DELETE_STATE, new PutIndexStateManagementPolicyRequest.Policy.State.Transition.Conditions(this.configuration.retention.getMinimumAge()))));
        PutIndexStateManagementPolicyRequest.Policy.State deleteState = new PutIndexStateManagementPolicyRequest.Policy.State(ISM_DELETE_STATE, List.of(new PutIndexStateManagementPolicyRequest.Policy.State.Action(new PutIndexStateManagementPolicyRequest.Policy.State.DeleteAction())), Collections.emptyList());
        PutIndexStateManagementPolicyRequest.Policy policy = new PutIndexStateManagementPolicyRequest.Policy(this.configuration.retention.getPolicyDescription(), ISM_INITIAL_STATE, List.of(initialState, deleteState), new PutIndexStateManagementPolicyRequest.Policy.IsmTemplate(List.of(this.configuration.index.prefix + "*"), 1));
        return new PutIndexStateManagementPolicyRequest(policy);
    }

    private <T> T sendRequest(Request request, Class<T> responseType) throws IOException {
        Response response = this.client.performRequest(request);
        byte[] responseBody = response.getEntity().getContent().readAllBytes();
        return (T)MAPPER.readValue(responseBody, responseType);
    }
}

