/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter.opensearch;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;

public class OpensearchMetrics {
    private static final String NAMESPACE = "zeebe.opensearch.exporter";
    private final MeterRegistry meterRegistry;
    private final AtomicInteger bulkMemorySize = new AtomicInteger(0);

    public OpensearchMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public Timer.ResourceSample measureFlushDuration() {
        return (Timer.ResourceSample)((Timer.ResourceSample)((Timer.ResourceSample)Timer.resource((MeterRegistry)this.meterRegistry, (String)this.meterName("flush.duration.seconds")).description("Flush duration of bulk exporters in seconds")).publishPercentileHistogram()).minimumExpectedValue(Duration.ofMillis(10L));
    }

    public void recordBulkSize(int bulkSize) {
        DistributionSummary.builder((String)this.meterName("bulk.size")).description("Exporter bulk size").serviceLevelObjectives(new double[]{10.0, 100.0, 1000.0, 10000.0, 100000.0}).register(this.meterRegistry).record((double)bulkSize);
    }

    public void recordBulkMemorySize(int bulkMemorySize) {
        Gauge.builder((String)this.meterName("bulk.memory.size"), (Object)this.bulkMemorySize, AtomicInteger::get).description("Exporter bulk memory size").register(this.meterRegistry);
        this.bulkMemorySize.set(bulkMemorySize);
    }

    public void recordFailedFlush() {
        Counter.builder((String)this.meterName("failed.flush")).description("Number of failed flush operations").register(this.meterRegistry).increment();
    }

    private String meterName(String name) {
        return "zeebe.opensearch.exporter." + name;
    }
}

