/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter.opensearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.exporter.opensearch.OpensearchExporter;
import io.camunda.zeebe.exporter.opensearch.OpensearchExporterConfiguration;
import io.camunda.zeebe.exporter.opensearch.OpensearchExporterException;
import io.camunda.zeebe.exporter.opensearch.dto.Template;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.util.VersionUtil;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;

final class TemplateReader {
    private static final String INDEX_TEMPLATE_FILENAME_PATTERN = "/zeebe-record-%s-template.json";
    private static final String ZEEBE_RECORD_TEMPLATE_JSON = "/zeebe-record-template.json";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final OpensearchExporterConfiguration.IndexConfiguration config;

    public TemplateReader(OpensearchExporterConfiguration.IndexConfiguration config) {
        this.config = config;
    }

    Template readComponentTemplate() {
        return this.readTemplate(ZEEBE_RECORD_TEMPLATE_JSON);
    }

    Template readIndexTemplate(ValueType valueType, String searchPattern, String aliasName) {
        Template template = this.readTemplate(this.findResourceForTemplate(valueType));
        template.composedOf().set(0, this.config.prefix + "-" + VersionUtil.getVersionLowerCase());
        template.patterns().set(0, searchPattern);
        template.template().aliases().clear();
        template.template().aliases().put(aliasName, Collections.emptyMap());
        return template;
    }

    private String findResourceForTemplate(ValueType valueType) {
        return String.format(INDEX_TEMPLATE_FILENAME_PATTERN, this.valueTypeToString(valueType));
    }

    private String valueTypeToString(ValueType valueType) {
        return valueType.name().toLowerCase().replace("_", "-");
    }

    private Template readTemplate(String resourcePath) {
        Template template = this.getTemplateFromClasspath(resourcePath);
        Map<String, Object> settings = template.template().settings();
        this.substituteConfiguration(settings);
        return template;
    }

    private void substituteConfiguration(Map<String, Object> settings) {
        Integer numberOfReplicas;
        Integer numberOfShards = this.config.getNumberOfShards();
        if (numberOfShards != null) {
            settings.put("number_of_shards", numberOfShards);
        }
        if ((numberOfReplicas = this.config.getNumberOfReplicas()) != null) {
            settings.put("number_of_replicas", numberOfReplicas);
        }
    }

    private Template getTemplateFromClasspath(String filename) {
        Template template;
        block8: {
            InputStream inputStream = OpensearchExporter.class.getResourceAsStream(filename);
            try {
                template = (Template)MAPPER.readValue(inputStream, Template.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new OpensearchExporterException("Failed to load index template from classpath " + filename, e);
                }
            }
            inputStream.close();
        }
        return template;
    }
}

