/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.google.common.base.Preconditions;
import com.netflix.concurrency.limits.limit.AbstractLimit;
import java.util.concurrent.TimeUnit;

public final class StabilizingAIMDLimit
extends AbstractLimit {
    private static final long DEFAULT_MAX_RTT = TimeUnit.SECONDS.toNanos(2L);
    private final int minLimit;
    private final int maxLimit;
    private final double backoffRatio;
    private final long expectedRTT;

    private StabilizingAIMDLimit(int initialLimit, int maxLimit, int minLimit, double backoffRatio, long expectedRTT) {
        super(initialLimit);
        this.maxLimit = maxLimit;
        this.minLimit = minLimit;
        this.backoffRatio = backoffRatio;
        this.expectedRTT = expectedRTT;
    }

    protected int _update(long startTime, long rtt, int inflight, boolean didDrop) {
        int currentLimit = this.getLimit();
        if (didDrop || rtt > this.expectedRTT) {
            if (inflight <= currentLimit) {
                currentLimit = (int)((double)currentLimit * this.backoffRatio);
            }
        } else if (inflight * 2 >= currentLimit) {
            ++currentLimit;
        }
        return Math.min(this.maxLimit, Math.max(this.minLimit, currentLimit));
    }

    public String toString() {
        return "StabilizingAIMDLimit [limit=" + this.getLimit() + "]";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private int minLimit = 10;
        private int initialLimit = 100;
        private int maxLimit = 1000;
        private double backoffRatio = 0.9;
        private long expectedRtt = DEFAULT_MAX_RTT;

        public Builder initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return this;
        }

        public Builder minLimit(int minLimit) {
            this.minLimit = minLimit;
            return this;
        }

        public Builder maxLimit(int maxLimit) {
            this.maxLimit = maxLimit;
            return this;
        }

        public Builder backoffRatio(double backoffRatio) {
            Preconditions.checkArgument((backoffRatio < 1.0 && backoffRatio >= 0.5 ? 1 : 0) != 0, (Object)"Backoff ratio must be in the range [0.5, 1.0)");
            this.backoffRatio = backoffRatio;
            return this;
        }

        public Builder expectedRTT(long timeout, TimeUnit units) {
            Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0, (Object)"Timeout must be positive");
            this.expectedRtt = units.toNanos(timeout);
            return this;
        }

        public StabilizingAIMDLimit build() {
            return new StabilizingAIMDLimit(this.initialLimit, this.maxLimit, this.minLimit, this.backoffRatio, this.expectedRtt);
        }
    }
}

