/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limiter.AbstractLimiter;
import io.camunda.zeebe.logstreams.impl.LogStreamMetrics;
import io.camunda.zeebe.logstreams.impl.flowcontrol.WhiteListedCommands;
import io.camunda.zeebe.protocol.record.intent.Intent;
import java.util.Optional;

public final class RequestLimiter
extends AbstractLimiter<Intent> {
    private final LogStreamMetrics metrics;

    private RequestLimiter(CommandRateLimiterBuilder builder, LogStreamMetrics metrics) {
        super((AbstractLimiter.Builder)builder);
        this.metrics = metrics;
        metrics.setInflightRequests(0);
        metrics.setRequestLimit(this.getLimit());
    }

    public Optional<Limiter.Listener> acquire(Intent intent) {
        if (this.getInflight() >= this.getLimit() && !WhiteListedCommands.isWhitelisted(intent)) {
            return this.createRejectedListener();
        }
        Limiter.Listener listener = this.createListener();
        return Optional.of(listener);
    }

    protected void onNewLimit(int newLimit) {
        super.onNewLimit(newLimit);
        this.metrics.setRequestLimit(newLimit);
    }

    public static CommandRateLimiterBuilder builder() {
        return new CommandRateLimiterBuilder();
    }

    public static class CommandRateLimiterBuilder
    extends AbstractLimiter.Builder<CommandRateLimiterBuilder> {
        protected CommandRateLimiterBuilder self() {
            return this;
        }

        public RequestLimiter build(LogStreamMetrics metrics) {
            return new RequestLimiter(this, metrics);
        }
    }
}

