/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.netflix.concurrency.limits.Limit;
import io.camunda.zeebe.logstreams.impl.LogStreamMetrics;
import io.camunda.zeebe.logstreams.impl.flowcontrol.FlowControl;
import io.camunda.zeebe.logstreams.impl.flowcontrol.InFlightEntry;
import io.camunda.zeebe.logstreams.impl.flowcontrol.RateLimit;
import io.camunda.zeebe.logstreams.impl.flowcontrol.StabilizingAIMDLimit;
import io.camunda.zeebe.logstreams.impl.flowcontrol.WhiteListedCommands;
import io.camunda.zeebe.logstreams.impl.log.LogAppendEntryMetadata;
import io.camunda.zeebe.logstreams.log.WriteContext;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.test.util.asserts.EitherAssert;
import io.camunda.zeebe.util.Either;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.AutoClose;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class FlowControlTest {
    @AutoClose
    MeterRegistry meterRegistry;
    FlowControl flowControl;

    @BeforeEach
    public void setup() {
        this.meterRegistry = new SimpleMeterRegistry();
        LogStreamMetrics logStreamMetrics = new LogStreamMetrics(this.meterRegistry);
        RateLimit writeRateLimit = new RateLimit(true, 1, Duration.ofSeconds(10L), new RateLimit.Throttling(true, 1L, 0L, Duration.ofSeconds(1L)));
        this.flowControl = new FlowControl(logStreamMetrics, (Limit)StabilizingAIMDLimit.newBuilder().build(), writeRateLimit);
    }

    static Stream<Intent> intentClassesProvider() {
        return Intent.INTENT_CLASSES.stream().flatMap(c -> Arrays.stream((Intent[])c.getEnumConstants()));
    }

    @ParameterizedTest
    @MethodSource(value={"intentClassesProvider"})
    public void shouldBlockCommandsBasedOnIntent(Intent intent) {
        WriteContext.UserCommand writeContext = new WriteContext.UserCommand(intent);
        List<Either<FlowControl.Rejection, InFlightEntry>> permits = this.acquireMultiplePermits((WriteContext)writeContext, writeContext.intent(), ValueType.JOB, 10);
        ((ObjectAssert)Assertions.assertThat(permits).first()).satisfies(new ThrowingConsumer[]{first -> EitherAssert.assertThat((Either)first).isRight()});
        Assertions.assertThat(permits.subList(1, permits.size())).allSatisfy(permit -> {
            if (WhiteListedCommands.isWhitelisted((Intent)intent)) {
                EitherAssert.assertThat((Either)permit).isRight();
            } else {
                EitherAssert.assertThat((Either)permit).isLeft().left().satisfies(new ThrowingConsumer[]{r -> Assertions.assertThat((Comparable)r).isEqualTo((Object)FlowControl.Rejection.WriteRateLimitExhausted)});
            }
        });
    }

    @ParameterizedTest
    @MethodSource(value={"intentClassesProvider"})
    public void shouldNeverBlockInternalCommands(Intent intent) {
        WriteContext writeContext = WriteContext.internal();
        List<Either<FlowControl.Rejection, InFlightEntry>> permits = this.acquireMultiplePermits(writeContext, intent, ValueType.JOB, 10);
        ((ObjectAssert)Assertions.assertThat(permits).first()).satisfies(new ThrowingConsumer[]{first -> EitherAssert.assertThat((Either)first).isRight()});
        Assertions.assertThat(permits.subList(1, permits.size())).allSatisfy(permit -> EitherAssert.assertThat((Either)permit).isRight());
    }

    private List<Either<FlowControl.Rejection, InFlightEntry>> acquireMultiplePermits(WriteContext writeContext, Intent intent, ValueType valueType, int n) {
        return IntStream.range(1, n).mapToObj(i -> this.flowControl.tryAcquire(writeContext, List.of(new LogAppendEntryMetadata(RecordType.COMMAND, valueType, intent)))).toList();
    }
}

