/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;

public enum LogStreamMetricsDoc implements ExtendedMeterDocumentation
{
    FLOW_CONTROL_OUTCOME{

        public String getDescription() {
            return "The count of records passing through the flow control, organized by context and outcome";
        }

        public String getName() {
            return "zeebe.flow.control";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return super.getKeyNames();
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    TOTAL_DEFERRED_APPEND_COUNT{

        public String getDescription() {
            return "Number of deferred appends due to backpressure";
        }

        public String getName() {
            return "zeebe.deferred.append.count.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    TOTAL_APPEND_TRY_COUNT{

        public String getDescription() {
            return "Number of tries to append";
        }

        public String getName() {
            return "zeebe.try.to.append.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    INFLIGHT_APPENDS{

        public String getDescription() {
            return "Current number of append inflight";
        }

        public String getName() {
            return "zeebe.backpressure.inflight.append.count";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    TOTAL_RECEIVED_REQUESTS{

        public String getDescription() {
            return "Number of requests received";
        }

        public String getName() {
            return "zeebe.received.request.count.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    TOTAL_DROPPED_REQUESTS{

        public String getDescription() {
            return "Number of requests dropped due to backpressure";
        }

        public String getName() {
            return "zeebe.dropped.request.count.total";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    INFLIGHT_REQUESTS{

        public String getDescription() {
            return "Current number of request inflight";
        }

        public String getName() {
            return "zeebe.backpressure.inflight.requests.count";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    REQUEST_LIMIT{

        public String getDescription() {
            return "Current limit for number of inflight requests";
        }

        public String getName() {
            return "zeebe.backpressure.requests.limit";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    CURRENT_LIMIT{

        public String getDescription() {
            return "Current limit for number of inflight appends";
        }

        public String getName() {
            return "zeebe.backpressure.append.limit";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    LAST_COMMITTED_POSITION{

        public String getDescription() {
            return "The last committed position";
        }

        public String getName() {
            return "zeebe.log.appender.last.committed.position";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    LAST_WRITTEN_POSITION{

        public String getDescription() {
            return "The last appended position by the appender";
        }

        public String getName() {
            return "zeebe.log.appender.last.appended.position";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    WRITE_LATENCY{

        public String getDescription() {
            return "Latency to append an event to the log in seconds";
        }

        public String getName() {
            return "zeebe.log.appender.append.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    COMMIT_LATENCY{

        public String getDescription() {
            return "Latency to commit an event to the log in seconds";
        }

        public String getName() {
            return "zeebe.log.appender.commit.latency";
        }

        public Meter.Type getType() {
            return Meter.Type.TIMER;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    RECORD_APPENDED{

        public String getDescription() {
            return "Count of records appended per partition, record type, value type, and intent";
        }

        public String getName() {
            return "zeebe.log.appender.record.appended";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return RecordAppendedKeyNames.values();
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    PARTITION_LOAD{

        public String getDescription() {
            return "The current load of the partition. Determined by observed write rate compared to the write rate limit";
        }

        public String getName() {
            return "zeebe.flow.control.partition.load";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    WRITE_RATE_LIMIT{

        public String getDescription() {
            return "The current write rate limit";
        }

        public String getName() {
            return "zeebe.flow.control.write.rate.limit";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    WRITE_RATE_MAX_LIMIT{

        public String getDescription() {
            return "The maximum write rate limit";
        }

        public String getName() {
            return "zeebe.flow.control.write.rate.maximum";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    }
    ,
    EXPORTING_RATE{

        public String getDescription() {
            return "The rate of exporting records from the log appender";
        }

        public String getName() {
            return "zeebe.flow.control.exporting.rate";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }

        public KeyName[] getAdditionalKeyNames() {
            return MicrometerUtil.PartitionKeyNames.values();
        }
    };


    public static enum FlowControlContext {
        USER_COMMAND("userCommand"),
        PROCESSING_RESULT("processingResult"),
        INTER_PARTITION("interPartition"),
        SCHEDULED("scheduled"),
        INTERNAL("internal");

        private final String value;

        private FlowControlContext(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum FlowControlOutcome {
        ACCEPTED("accepted"),
        WRITE_RATE_LIMIT_EXHAUSTED("writeRateLimitExhausted"),
        REQUEST_LIMIT_EXHAUSTED("requestLimitExhausted");

        private final String value;

        private FlowControlOutcome(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum FlowControlKeyNames implements KeyName
    {
        CONTEXT{

            public String asString() {
                return "context";
            }
        }
        ,
        OUTCOME{

            public String asString() {
                return "outcome";
            }
        };

    }

    public static enum RecordAppendedKeyNames implements KeyName
    {
        RECORD_TYPE{

            public String asString() {
                return "recordType";
            }
        }
        ,
        VALUE_TYPE{

            public String asString() {
                return "valueType";
            }
        }
        ,
        INTENT{

            public String asString() {
                return "intent";
            }
        };

    }
}

