/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.util;

import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.logstreams.storage.LogStorageReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongConsumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ListLogStorage
implements LogStorage {
    private final ConcurrentNavigableMap<Long, Integer> positionIndexMapping;
    private final ConcurrentSkipListMap<Integer, Entry> entries;
    private LongConsumer positionListener;
    private final Set<LogStorage.CommitListener> commitListeners = new HashSet<LogStorage.CommitListener>();
    private final List<ListLogStorageReader> listLogStorageReaders;
    private final AtomicInteger currentIndex = new AtomicInteger(0);

    public ListLogStorage() {
        this.entries = new ConcurrentSkipListMap();
        this.positionIndexMapping = new ConcurrentSkipListMap<Long, Integer>();
        this.listLogStorageReaders = new CopyOnWriteArrayList<ListLogStorageReader>();
    }

    public void setPositionListener(LongConsumer positionListener) {
        this.positionListener = positionListener;
    }

    public LogStorageReader newReader() {
        ListLogStorageReader listLogStorageReader = new ListLogStorageReader();
        this.listLogStorageReaders.add(listLogStorageReader);
        return listLogStorageReader;
    }

    public void append(long lowestPosition, long highestPosition, BufferWriter bufferWriter, LogStorage.AppendListener listener) {
        ByteBuffer buffer = ByteBuffer.allocate(bufferWriter.getLength());
        bufferWriter.write((MutableDirectBuffer)new UnsafeBuffer(buffer), 0);
        this.append(lowestPosition, highestPosition, buffer, listener);
    }

    public void append(long lowestPosition, long highestPosition, ByteBuffer blockBuffer, LogStorage.AppendListener listener) {
        Entry entry = new Entry(blockBuffer);
        int index = this.currentIndex.getAndIncrement();
        this.entries.put(index, entry);
        this.positionIndexMapping.put(lowestPosition, index);
        listener.onWrite((long)index, highestPosition);
        if (this.positionListener != null) {
            this.positionListener.accept(highestPosition);
        }
        listener.onCommit((long)index, highestPosition);
        this.commitListeners.forEach(LogStorage.CommitListener::onCommit);
    }

    public void addCommitListener(LogStorage.CommitListener listener) {
        this.commitListeners.add(listener);
    }

    public void removeCommitListener(LogStorage.CommitListener listener) {
        this.commitListeners.remove(listener);
    }

    public void reset() {
        Integer lastIndex = this.listLogStorageReaders.stream().map(r -> r.currentIndex).min(Integer::compareTo).orElse(0);
        this.entries.headMap((Object)lastIndex).clear();
    }

    private final class ListLogStorageReader
    implements LogStorageReader {
        volatile int currentIndex;

        private ListLogStorageReader() {
        }

        public void seek(long position) {
            this.currentIndex = Optional.ofNullable(ListLogStorage.this.positionIndexMapping.lowerEntry(position)).map(Map.Entry::getValue).orElse(0);
        }

        public void close() {
            ListLogStorage.this.listLogStorageReaders.remove(this);
        }

        public boolean hasNext() {
            return this.currentIndex >= 0 && !ListLogStorage.this.entries.tailMap((Object)this.currentIndex).isEmpty();
        }

        public DirectBuffer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int index = this.currentIndex++;
            return new UnsafeBuffer(ListLogStorage.this.entries.get((Object)Integer.valueOf((int)index)).data);
        }
    }

    private record Entry(ByteBuffer data) {
    }
}

