/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.logstreams.impl.LogStreamMetrics;
import io.camunda.zeebe.logstreams.impl.flowcontrol.FlowControl;
import io.camunda.zeebe.logstreams.impl.log.LogStreamReaderImpl;
import io.camunda.zeebe.logstreams.impl.log.Sequencer;
import io.camunda.zeebe.logstreams.impl.log.SequencerMetrics;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.logstreams.log.WriteContext;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.logstreams.util.ListLogStorage;
import io.camunda.zeebe.logstreams.util.TestEntry;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.nio.ByteBuffer;
import java.time.InstantSource;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.agrona.CloseHelper;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Execution(value=ExecutionMode.CONCURRENT)
final class LogStorageAppenderTest {
    private static final int PARTITION_ID = 0;
    private static final long INITIAL_POSITION = 2L;
    private final ActorScheduler scheduler = ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(1).setIoBoundActorThreadCount(1).build();
    private final ListLogStorage logStorage = (ListLogStorage)Mockito.spy((Object)new ListLogStorage());
    private Sequencer sequencer;
    private LogStreamReader reader;

    LogStorageAppenderTest() {
    }

    @BeforeEach
    void beforeEach() {
        SimpleMeterRegistry meterRegistry = new SimpleMeterRegistry();
        LogStreamMetrics logStreamMetrics = new LogStreamMetrics((MeterRegistry)meterRegistry);
        this.scheduler.start();
        this.sequencer = new Sequencer((LogStorage)this.logStorage, 2L, 0x400000, InstantSource.system(), new SequencerMetrics((MeterRegistry)meterRegistry), new FlowControl(logStreamMetrics));
        this.reader = new LogStreamReaderImpl(this.logStorage.newReader());
    }

    @AfterEach
    public void tearDown() {
        CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{this.sequencer});
    }

    @Test
    void shouldAppendSingleEvent() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        LogAppendEntry entry = TestEntry.ofDefaults();
        this.logStorage.setPositionListener(i -> latch.countDown());
        Long position = (Long)this.sequencer.tryWrite(WriteContext.internal(), entry).get();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(5L, TimeUnit.SECONDS)).as("value was written within 5 seconds", new Object[0])).isTrue();
        Assertions.assertThat((boolean)this.reader.seek(position.longValue())).isTrue();
        Assertions.assertThat((boolean)this.reader.hasNext()).isTrue();
        TestEntry.TestEntryAssert.assertThatEntry(entry).matchesLoggedEvent((LoggedEvent)this.reader.next());
    }

    @Test
    void shouldAppendMultipleEvents() throws InterruptedException {
        List entries = IntStream.range(0, 2).mapToObj(i -> TestEntry.ofDefaults()).collect(Collectors.toList());
        CountDownLatch latch = new CountDownLatch(1);
        this.logStorage.setPositionListener(i -> latch.countDown());
        Long highestPosition = (Long)this.sequencer.tryWrite(WriteContext.internal(), entries).get();
        long lowestPosition = highestPosition - 1L;
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)latch.await(5L, TimeUnit.SECONDS)).as("value was written within 5 seconds", new Object[0])).isTrue();
        ((ListLogStorage)Mockito.verify((Object)this.logStorage, (VerificationMode)Mockito.timeout((long)1000L).times(1))).append(ArgumentMatchers.eq((long)lowestPosition), (long)((Long)ArgumentMatchers.eq((Object)highestPosition)), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), (LogStorage.AppendListener)ArgumentMatchers.any(LogStorage.AppendListener.class));
        Assertions.assertThat((boolean)this.reader.seek(lowestPosition)).isTrue();
        for (LogAppendEntry entry : entries) {
            Assertions.assertThat((boolean)this.reader.hasNext()).isTrue();
            TestEntry.TestEntryAssert.assertThatEntry(entry).matchesLoggedEvent((LoggedEvent)this.reader.next());
        }
    }
}

