/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import io.camunda.zeebe.logstreams.impl.flowcontrol.RateMeasurement;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RateMeasurementTest {
    RateMeasurementTest() {
    }

    @Test
    void shouldMeasureZeroWithoutObservations() {
        AtomicLong clock = new AtomicLong(0L);
        RateMeasurement rateMeasurement = new RateMeasurement(clock::get, Duration.ofMinutes(5L), Duration.ofSeconds(10L));
        double rate = rateMeasurement.rate();
        Assertions.assertThat((double)rate).isEqualTo(0.0);
    }

    @Test
    void shouldMeasureExpectedRate() {
        AtomicLong clock = new AtomicLong(0L);
        Duration observationWindow = Duration.ofMinutes(5L);
        RateMeasurement rateMeasurement = new RateMeasurement(clock::get, observationWindow, Duration.ofSeconds(10L));
        rateMeasurement.observe(0L);
        clock.set(observationWindow.toMillis());
        rateMeasurement.observe(12345L);
        Assertions.assertThat((long)rateMeasurement.rate()).isEqualTo(12345L / observationWindow.toSeconds());
    }

    @Test
    void shouldMeasureRate() {
        AtomicLong clock = new AtomicLong(0L);
        Duration observationWindow = Duration.ofMinutes(5L);
        RateMeasurement rateMeasurement = new RateMeasurement(clock::get, observationWindow, Duration.ofSeconds(1L));
        int second = 0;
        while ((long)second <= observationWindow.toSeconds()) {
            clock.set((long)second * 1000L);
            rateMeasurement.observe((long)second * 10L);
            ++second;
        }
        Assertions.assertThat((long)rateMeasurement.rate()).isEqualTo(10L);
    }
}

