/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.google.common.util.concurrent.RateLimiter;
import java.time.Duration;
import java.util.Objects;

public record RateLimit(boolean enabled, int limit, Duration rampUp, Throttling throttling) {
    public RateLimit {
        Objects.requireNonNull(throttling, "throttling must not be null");
        Objects.requireNonNull(rampUp, "rampUp must not be null");
        if (enabled && limit <= 0) {
            throw new IllegalArgumentException("limit must be greater than 0");
        }
        if (enabled && rampUp.isNegative()) {
            throw new IllegalArgumentException("rampUp cannot be negative");
        }
        if (enabled && throttling.enabled() && throttling.minRate() > (long)limit) {
            throw new IllegalArgumentException("minimum throttling rate must not be larger than the regular limit");
        }
    }

    public static RateLimit disabled() {
        return new RateLimit(false, 0, Duration.ZERO, Throttling.disabled());
    }

    public RateLimiter limiter() {
        if (!this.enabled) {
            return null;
        }
        if (this.rampUp.isZero()) {
            return RateLimiter.create((double)this.limit);
        }
        return RateLimiter.create((double)this.limit, (Duration)this.rampUp);
    }

    public record Throttling(boolean enabled, long acceptableBacklog, long minRate, Duration resolution) {
        public Throttling {
            Objects.requireNonNull(resolution, "resolution must not be null");
            if (enabled && resolution.isZero()) {
                throw new IllegalArgumentException("resolution must be greater than 0");
            }
            if (enabled && acceptableBacklog < 0L) {
                throw new IllegalArgumentException("acceptableBacklog must be greater than 0");
            }
            if (enabled && minRate < 0L) {
                throw new IllegalArgumentException("minRate must be greater than 0");
            }
        }

        static Throttling disabled() {
            return new Throttling(false, 0L, 0L, Duration.ZERO);
        }
    }
}

