/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.serializer;

import io.camunda.zeebe.logstreams.impl.log.LoggedEventImpl;
import io.camunda.zeebe.logstreams.impl.log.SequencedBatch;
import io.camunda.zeebe.logstreams.impl.serializer.SequencedBatchSerializer;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.logstreams.util.TestEntry;
import java.nio.ByteBuffer;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class SequencedBatchSerializerTest {
    SequencedBatchSerializerTest() {
    }

    @Test
    void serializedBatchIsReadableAsLoggedEvents() {
        List<LogAppendEntry> entries = List.of(TestEntry.ofKey(1L), TestEntry.ofKey(2L));
        SequencedBatch batch = new SequencedBatch(0L, 1L, -1L, entries);
        ByteBuffer serialized = SequencedBatchSerializer.serializeBatch((SequencedBatch)batch);
        LoggedEventImpl firstEvent = new LoggedEventImpl();
        firstEvent.wrap((DirectBuffer)new UnsafeBuffer(serialized), 0);
        TestEntry.TestEntryAssert.assertThatEntry(entries.get(0)).matchesLoggedEvent((LoggedEvent)firstEvent);
        Assertions.assertThat((long)firstEvent.getPosition()).isEqualTo(1L);
        Assertions.assertThat((long)firstEvent.getSourceEventPosition()).isEqualTo(-1L);
        LoggedEventImpl secondEvent = new LoggedEventImpl();
        secondEvent.wrap((DirectBuffer)new UnsafeBuffer(serialized), firstEvent.getLength());
        TestEntry.TestEntryAssert.assertThatEntry(entries.get(1)).matchesLoggedEvent((LoggedEvent)secondEvent);
        Assertions.assertThat((long)secondEvent.getPosition()).isEqualTo(2L);
        Assertions.assertThat((long)secondEvent.getSourceEventPosition()).isEqualTo(-1L);
    }
}

