/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.google.common.util.concurrent.RateLimiter;
import io.camunda.zeebe.logstreams.impl.LogStreamMetrics;
import io.camunda.zeebe.logstreams.impl.flowcontrol.RateLimit;
import io.camunda.zeebe.logstreams.impl.flowcontrol.RateMeasurement;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RateLimitThrottle {
    private static final Logger LOG = LoggerFactory.getLogger(RateLimitThrottle.class);
    private final AtomicLong lastUpdate = new AtomicLong(-1L);
    private final LogStreamMetrics metrics;
    private final RateLimit limit;
    private final RateLimiter limiter;
    private final RateMeasurement measurement;
    private final long resolution;
    private final boolean enabled;
    private final double minRate;

    RateLimitThrottle(LogStreamMetrics metrics, RateLimit limit, RateLimiter limiter, RateMeasurement measurement) {
        this.metrics = metrics;
        this.limit = limit;
        this.limiter = limiter;
        this.measurement = measurement;
        this.resolution = limit == null ? -1L : limit.throttling().resolution().toMillis();
        this.enabled = limit != null && limit.enabled() && limit.throttling().enabled();
        this.minRate = limit == null ? -1.0 : (double)limit.throttling().minRate();
    }

    public void update(long timestamp, long backlog) {
        double adjustedRate;
        if (!this.enabled) {
            return;
        }
        if (this.canSkipUpdate(timestamp)) {
            return;
        }
        double factor = (double)this.limit.throttling().acceptableBacklog() / (double)backlog;
        long rate = this.measurement.rate();
        double d = adjustedRate = factor > 2.0 ? (double)this.limit.limit() : Math.clamp(factor * (double)rate, this.minRate, (double)this.limit.limit());
        if (adjustedRate < (double)this.limit.limit()) {
            LOG.debug("Throttling to {}, {} of observed rate {}, Current backlog {}, acceptable {}", new Object[]{String.format("%.2f", adjustedRate), String.format("%.2f", factor), rate, backlog, this.limit.throttling().acceptableBacklog()});
        }
        this.limiter.setRate(adjustedRate);
        this.metrics.setWriteRateMaxLimit(this.limit.limit());
        this.metrics.setWriteRateLimit(adjustedRate);
    }

    private boolean canSkipUpdate(long timestamp) {
        return this.lastUpdate.updateAndGet(lastUpdate -> {
            if (timestamp - lastUpdate < this.resolution) {
                return lastUpdate;
            }
            return timestamp;
        }) != timestamp;
    }
}

