/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.util;

import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.logstreams.util.LogStreamRule;
import io.camunda.zeebe.logstreams.util.SynchronousLogStream;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.rules.ExternalResource;

public final class LogStreamReaderRule
extends ExternalResource {
    private final LogStreamRule logStreamRule;
    private LogStreamReader logStreamReader;

    public LogStreamReaderRule(LogStreamRule logStreamRule) {
        this.logStreamRule = logStreamRule;
    }

    protected void before() {
        SynchronousLogStream logStream = this.logStreamRule.getLogStream();
        this.logStreamReader = logStream.newLogStreamReader();
    }

    protected void after() {
        this.logStreamReader.close();
    }

    public LogStreamReader getLogStreamReader() {
        return this.logStreamReader;
    }

    public LoggedEvent nextEvent() {
        Assertions.assertThat((boolean)this.logStreamReader.hasNext()).isTrue();
        return (LoggedEvent)this.logStreamReader.next();
    }

    public LoggedEvent readEventAtPosition(long position) {
        while (this.logStreamReader.hasNext()) {
            LoggedEvent event = (LoggedEvent)this.logStreamReader.next();
            if (event.getPosition() != position) continue;
            return event;
        }
        return null;
    }

    private DirectBuffer eventValue(LoggedEvent event) {
        Assertions.assertThat((Object)event).isNotNull();
        return new UnsafeBuffer(event.getValueBuffer(), event.getValueOffset(), event.getValueLength());
    }

    public LogStreamReader resetReader() {
        this.logStreamReader = this.logStreamRule.newLogStreamReader();
        return this.logStreamReader;
    }
}

