/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.log;

import io.camunda.zeebe.protocol.record.intent.Intent;

public sealed interface WriteContext {
    public static WriteContext userCommand(Intent intent) {
        return new UserCommand(intent);
    }

    public static WriteContext processingResult() {
        return ProcessingResult.INSTANCE;
    }

    public static WriteContext interPartition() {
        return InterPartition.INSTANCE;
    }

    public static WriteContext scheduled() {
        return Scheduled.INSTANCE;
    }

    public static WriteContext internal() {
        return Internal.INSTANCE;
    }

    public record UserCommand(Intent intent) implements WriteContext
    {
    }

    public static final class ProcessingResult
    implements WriteContext {
        private static final ProcessingResult INSTANCE = new ProcessingResult();
    }

    public static final class InterPartition
    implements WriteContext {
        private static final InterPartition INSTANCE = new InterPartition();
    }

    public static final class Scheduled
    implements WriteContext {
        private static final Scheduled INSTANCE = new Scheduled();
    }

    public static final class Internal
    implements WriteContext {
        private static final Internal INSTANCE = new Internal();
    }
}

