/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl;

import io.camunda.zeebe.logstreams.impl.flowcontrol.FlowControl;
import io.camunda.zeebe.logstreams.impl.log.LogAppendEntryMetadata;
import io.camunda.zeebe.logstreams.log.WriteContext;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;

public final class LogStreamMetrics {
    private static final Counter FLOW_CONTROL_OUTCOME = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).subsystem("flow_control")).name("outcome")).help("The count of records passing through the flow control, organized by context and outcome")).labelNames(new String[]{"partition", "context", "outcome"})).register();
    private static final Counter TOTAL_DEFERRED_APPEND_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("deferred_append_count_total")).help("Number of deferred appends due to backpressure")).labelNames(new String[]{"partition"})).register();
    private static final Counter TOTAL_APPEND_TRY_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("try_to_append_total")).help("Number of tries to append")).labelNames(new String[]{"partition"})).register();
    private static final Gauge INFLIGHT_APPENDS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("backpressure_inflight_append_count")).help("Current number of append inflight")).labelNames(new String[]{"partition"})).register();
    private static final Counter TOTAL_RECEIVED_REQUESTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("received_request_count_total")).help("Number of requests received")).labelNames(new String[]{"partition"})).register();
    private static final Counter TOTAL_DROPPED_REQUESTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("dropped_request_count_total")).help("Number of requests dropped due to backpressure")).labelNames(new String[]{"partition"})).register();
    private static final Gauge INFLIGHT_REQUESTS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("backpressure_inflight_requests_count")).help("Current number of request inflight")).labelNames(new String[]{"partition"})).register();
    private static final Gauge REQUEST_LIMIT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("backpressure_requests_limit")).help("Current limit for number of inflight requests")).labelNames(new String[]{"partition"})).register();
    private static final Gauge LAST_COMMITTED_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("log_appender_last_committed_position")).help("The last committed position.")).labelNames(new String[]{"partition"})).register();
    private static final Gauge LAST_WRITTEN_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("log_appender_last_appended_position")).help("The last appended position by the appender.")).labelNames(new String[]{"partition"})).register();
    private static final Histogram WRITE_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("log_appender_append_latency")).help("Latency to append an event to the log in seconds")).labelNames(new String[]{"partition"})).register();
    private static final Histogram COMMIT_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("log_appender_commit_latency")).help("Latency to commit an event to the log in seconds")).labelNames(new String[]{"partition"})).register();
    private static final Counter RECORD_APPENDED = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).subsystem("log_appender")).name("record_appended")).labelNames(new String[]{"partition", "recordType", "valueType", "intent"})).help("Count of records appended per partition, record type, value type, and intent")).register();
    private static final Gauge EXPORTING_RATE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).subsystem("flow_control")).name("exporting_rate")).help("The rate of exporting records from the log appender")).labelNames(new String[]{"partition"})).register();
    private static final Gauge WRITE_RATE_MAX_LIMIT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).subsystem("flow_control")).name("write_rate_maximum")).help("The maximum write rate limit")).labelNames(new String[]{"partition"})).register();
    private static final Gauge WRITE_RATE_LIMIT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).subsystem("flow_control")).name("write_rate_limit")).help("The current write rate limit")).labelNames(new String[]{"partition"})).register();
    private static final Gauge PARTITION_LOAD = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).subsystem("flow_control")).name("partition_load")).labelNames(new String[]{"partition"})).help("The current load of the partition. Determined by observed write rate compared to the write rate limit")).register();
    private final Counter.Child deferredAppends;
    private final Counter.Child triedAppends;
    private final Gauge.Child inflightAppends;
    private final Counter.Child receivedRequests;
    private final Counter.Child droppedRequests;
    private final Gauge.Child inflightRequests;
    private final Gauge.Child requestLimit;
    private final Gauge.Child lastCommitted;
    private final Gauge.Child lastWritten;
    private final Histogram.Child commitLatency;
    private final Histogram.Child appendLatency;
    private final Gauge.Child exportingRate;
    private final Gauge.Child writeRateMaxLimit;
    private final Gauge.Child writeRateLimit;
    private final Gauge.Child partitionLoad;
    private final String partitionLabel;

    public LogStreamMetrics(int partitionId) {
        this.partitionLabel = String.valueOf(partitionId);
        this.deferredAppends = (Counter.Child)TOTAL_DEFERRED_APPEND_COUNT.labels(new String[]{this.partitionLabel});
        this.triedAppends = (Counter.Child)TOTAL_APPEND_TRY_COUNT.labels(new String[]{this.partitionLabel});
        this.inflightAppends = (Gauge.Child)INFLIGHT_APPENDS.labels(new String[]{this.partitionLabel});
        this.receivedRequests = (Counter.Child)TOTAL_RECEIVED_REQUESTS.labels(new String[]{this.partitionLabel});
        this.droppedRequests = (Counter.Child)TOTAL_DROPPED_REQUESTS.labels(new String[]{this.partitionLabel});
        this.inflightRequests = (Gauge.Child)INFLIGHT_REQUESTS.labels(new String[]{this.partitionLabel});
        this.requestLimit = (Gauge.Child)REQUEST_LIMIT.labels(new String[]{this.partitionLabel});
        this.lastCommitted = (Gauge.Child)LAST_COMMITTED_POSITION.labels(new String[]{this.partitionLabel});
        this.lastWritten = (Gauge.Child)LAST_WRITTEN_POSITION.labels(new String[]{this.partitionLabel});
        this.commitLatency = (Histogram.Child)COMMIT_LATENCY.labels(new String[]{this.partitionLabel});
        this.appendLatency = (Histogram.Child)WRITE_LATENCY.labels(new String[]{this.partitionLabel});
        this.exportingRate = (Gauge.Child)EXPORTING_RATE.labels(new String[]{this.partitionLabel});
        this.writeRateMaxLimit = (Gauge.Child)WRITE_RATE_MAX_LIMIT.labels(new String[]{this.partitionLabel});
        this.writeRateLimit = (Gauge.Child)WRITE_RATE_LIMIT.labels(new String[]{this.partitionLabel});
        this.partitionLoad = (Gauge.Child)PARTITION_LOAD.labels(new String[]{this.partitionLabel});
    }

    public void increaseInflightAppends() {
        this.inflightAppends.inc();
    }

    public void decreaseInflightAppends() {
        this.inflightAppends.dec();
    }

    public void setInflightRequests(int count) {
        this.inflightRequests.set((double)count);
    }

    public void setRequestLimit(int limit) {
        this.requestLimit.set((double)limit);
    }

    public void increaseInflightRequests() {
        this.inflightRequests.inc();
    }

    public void decreaseInflightRequests() {
        this.inflightRequests.dec();
    }

    public Histogram.Timer startWriteTimer() {
        return this.appendLatency.startTimer();
    }

    public Histogram.Timer startCommitTimer() {
        return this.commitLatency.startTimer();
    }

    public void setLastWrittenPosition(long position) {
        this.lastWritten.set((double)position);
    }

    public void setLastCommittedPosition(long position) {
        this.lastCommitted.set((double)position);
    }

    public void recordAppendedEntry(int amount, RecordType recordType, ValueType valueType, Intent intent) {
        ((Counter.Child)RECORD_APPENDED.labels(new String[]{this.partitionLabel, recordType.name(), valueType.name(), intent.name()})).inc((double)amount);
    }

    public void remove() {
        TOTAL_DEFERRED_APPEND_COUNT.remove(new String[]{this.partitionLabel});
        TOTAL_APPEND_TRY_COUNT.remove(new String[]{this.partitionLabel});
        INFLIGHT_APPENDS.remove(new String[]{this.partitionLabel});
        INFLIGHT_REQUESTS.remove(new String[]{this.partitionLabel});
        REQUEST_LIMIT.remove(new String[]{this.partitionLabel});
        LAST_COMMITTED_POSITION.remove(new String[]{this.partitionLabel});
        LAST_WRITTEN_POSITION.remove(new String[]{this.partitionLabel});
        COMMIT_LATENCY.remove(new String[]{this.partitionLabel});
        WRITE_LATENCY.remove(new String[]{this.partitionLabel});
        EXPORTING_RATE.remove(new String[]{this.partitionLabel});
        WRITE_RATE_MAX_LIMIT.remove(new String[]{this.partitionLabel});
        WRITE_RATE_LIMIT.remove(new String[]{this.partitionLabel});
        PARTITION_LOAD.remove(new String[]{this.partitionLabel});
        for (String contextLabel : FlowControlOutComeLabels.allContextLabels()) {
            for (String reasonLabel : FlowControlOutComeLabels.allReasonLabels()) {
                FLOW_CONTROL_OUTCOME.remove(new String[]{this.partitionLabel, contextLabel, reasonLabel});
            }
        }
    }

    public void flowControlAccepted(WriteContext context, List<LogAppendEntryMetadata> batchMetadata) {
        this.triedAppends.inc();
        if (context instanceof WriteContext.UserCommand) {
            this.receivedRequests.inc();
        }
        ((Counter.Child)FLOW_CONTROL_OUTCOME.labels(new String[]{this.partitionLabel, FlowControlOutComeLabels.labelForContext(context), "accepted"})).inc((double)batchMetadata.size());
    }

    public void flowControlRejected(WriteContext context, List<LogAppendEntryMetadata> batchMetadata, FlowControl.Rejection reason) {
        this.triedAppends.inc();
        this.deferredAppends.inc();
        if (context instanceof WriteContext.UserCommand) {
            this.receivedRequests.inc();
            this.droppedRequests.inc();
        }
        ((Counter.Child)FLOW_CONTROL_OUTCOME.labels(new String[]{this.partitionLabel, FlowControlOutComeLabels.labelForContext(context), FlowControlOutComeLabels.labelForReason(reason)})).inc((double)batchMetadata.size());
    }

    public void setPartitionLoad(float load) {
        this.partitionLoad.set((double)load);
    }

    public void setExportingRate(long value) {
        this.exportingRate.set((double)value);
    }

    public void setWriteRateMaxLimit(long value) {
        this.writeRateMaxLimit.set((double)value);
    }

    public void setWriteRateLimit(double value) {
        this.writeRateLimit.set(value);
    }

    static final class FlowControlOutComeLabels {
        private FlowControlOutComeLabels() {
        }

        static String[] allReasonLabels() {
            return (String[])EnumSet.allOf(FlowControl.Rejection.class).stream().map(FlowControlOutComeLabels::labelForReason).toArray(String[]::new);
        }

        static String[] allContextLabels() {
            WriteContextLabel[] labels = WriteContextLabel.values();
            String[] labelNames = new String[labels.length];
            for (int i = 0; i < labels.length; ++i) {
                labelNames[i] = labels[i].labelName;
            }
            return labelNames;
        }

        static String labelForReason(FlowControl.Rejection reason) {
            return switch (reason) {
                default -> throw new MatchException(null, null);
                case FlowControl.Rejection.WriteRateLimitExhausted -> "writeRateLimitExhausted";
                case FlowControl.Rejection.RequestLimitExhausted -> "requestLimitExhausted";
            };
        }

        static String labelForContext(WriteContext context) {
            WriteContext writeContext = context;
            Objects.requireNonNull(writeContext);
            WriteContext writeContext2 = writeContext;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WriteContext.UserCommand.class, WriteContext.ProcessingResult.class, WriteContext.InterPartition.class, WriteContext.Scheduled.class, WriteContext.Internal.class}, (Object)writeContext2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    WriteContext.UserCommand ignored = (WriteContext.UserCommand)writeContext2;
                    yield WriteContextLabel.UserCommand.labelName;
                }
                case 1 -> {
                    WriteContext.ProcessingResult ignored = (WriteContext.ProcessingResult)writeContext2;
                    yield WriteContextLabel.ProcessingResult.labelName;
                }
                case 2 -> {
                    WriteContext.InterPartition ignored = (WriteContext.InterPartition)writeContext2;
                    yield WriteContextLabel.InterPartition.labelName;
                }
                case 3 -> {
                    WriteContext.Scheduled ignored = (WriteContext.Scheduled)writeContext2;
                    yield WriteContextLabel.Scheduled.labelName;
                }
                case 4 -> {
                    WriteContext.Internal ignored = (WriteContext.Internal)writeContext2;
                    yield WriteContextLabel.Internal.labelName;
                }
            };
        }

        private static enum WriteContextLabel {
            UserCommand("userCommand"),
            ProcessingResult("processingResult"),
            InterPartition("interPartition"),
            Scheduled("scheduled"),
            Internal("internal");

            private final String labelName;

            private WriteContextLabel(String labelName) {
                this.labelName = labelName;
            }
        }
    }
}

