/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.util;

import com.netflix.concurrency.limits.Limit;
import io.camunda.zeebe.logstreams.impl.flowcontrol.RateLimit;
import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.logstreams.util.TestLogStream;
import java.time.InstantSource;

public final class TestLogStreamBuilder
implements LogStreamBuilder {
    private final LogStreamBuilder delegate;

    TestLogStreamBuilder() {
        this(LogStream.builder());
    }

    TestLogStreamBuilder(LogStreamBuilder delegate) {
        this.delegate = delegate;
    }

    public TestLogStreamBuilder withMaxFragmentSize(int maxFragmentSize) {
        this.delegate.withMaxFragmentSize(maxFragmentSize);
        return this;
    }

    public TestLogStreamBuilder withLogStorage(LogStorage logStorage) {
        this.delegate.withLogStorage(logStorage);
        return this;
    }

    public TestLogStreamBuilder withPartitionId(int partitionId) {
        this.delegate.withPartitionId(partitionId);
        return this;
    }

    public TestLogStreamBuilder withLogName(String logName) {
        this.delegate.withLogName(logName);
        return this;
    }

    public TestLogStreamBuilder withClock(InstantSource clock) {
        this.delegate.withClock(clock);
        return this;
    }

    public LogStreamBuilder withRequestLimit(Limit requestLimit) {
        this.delegate.withRequestLimit(requestLimit);
        return this;
    }

    public LogStreamBuilder withWriteRateLimit(RateLimit writeRateLimiter) {
        this.delegate.withWriteRateLimit(writeRateLimiter);
        return this;
    }

    public TestLogStream build() {
        return new TestLogStream(this.delegate.build());
    }
}

