/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.util;

import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.logstreams.util.ListLogStorage;
import io.camunda.zeebe.logstreams.util.TestLogStream;
import java.time.Instant;
import java.time.InstantSource;
import java.util.function.Consumer;
import org.agrona.CloseHelper;
import org.junit.rules.ExternalResource;

public final class LogStreamRule
extends ExternalResource {
    private final ControlledClock clock = new ControlledClock();
    private final boolean shouldStartByDefault;
    private final Consumer<LogStreamBuilder> streamBuilder;
    private TestLogStream logStream;
    private LogStreamReader logStreamReader;
    private LogStreamWriter logStreamWriter;
    private LogStreamBuilder builder;
    private ListLogStorage listLogStorage;

    private LogStreamRule(boolean shouldStart, Consumer<LogStreamBuilder> streamBuilder) {
        this.shouldStartByDefault = shouldStart;
        this.streamBuilder = streamBuilder;
    }

    public static LogStreamRule startByDefault(Consumer<LogStreamBuilder> streamBuilder) {
        return new LogStreamRule(true, streamBuilder);
    }

    public static LogStreamRule startByDefault() {
        return new LogStreamRule(true, b -> {});
    }

    protected void before() {
        if (this.shouldStartByDefault) {
            this.createLogStream();
        }
    }

    protected void after() {
        this.stopLogStream();
    }

    public void createLogStream() {
        if (this.listLogStorage == null) {
            this.listLogStorage = new ListLogStorage();
        }
        this.builder = LogStream.builder().withPartitionId(0).withLogName("logStream-0").withLogStorage((LogStorage)this.listLogStorage).withClock((InstantSource)this.clock);
        this.streamBuilder.accept(this.builder);
        this.openLogStream();
    }

    private void stopLogStream() {
        CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{this.logStreamReader, this.logStream});
        this.logStream = null;
        this.logStreamReader = null;
        this.logStreamWriter = null;
        this.listLogStorage = null;
    }

    private void openLogStream() {
        this.logStream = TestLogStream.builder(this.builder).build();
        this.listLogStorage.setPositionListener(this.logStream::setLastWrittenPosition);
    }

    public LogStreamReader newLogStreamReader() {
        return this.logStream.newLogStreamReader();
    }

    public LogStreamReader getLogStreamReader() {
        if (this.logStream == null) {
            throw new IllegalStateException("Log stream is not open!");
        }
        if (this.logStreamReader == null) {
            this.logStreamReader = this.logStream.newLogStreamReader();
        }
        return this.logStreamReader;
    }

    public LogStreamWriter getLogStreamWriter() {
        if (this.logStream == null) {
            throw new IllegalStateException("Log stream is not open!");
        }
        if (this.logStreamWriter == null) {
            this.logStreamWriter = this.logStream.newLogStreamWriter();
        }
        return this.logStreamWriter;
    }

    public TestLogStream getLogStream() {
        return this.logStream;
    }

    public ControlledClock getClock() {
        return this.clock;
    }

    public static final class ControlledClock
    implements InstantSource {
        public InstantSource delegate;

        @Override
        public Instant instant() {
            return this.delegate == null ? Instant.now() : this.delegate.instant();
        }
    }
}

