/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.logstreams.impl.log.LogEntryDescriptor;
import io.camunda.zeebe.protocol.Protocol;
import java.util.Arrays;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class LogEntryDescriptorTest {
    LogEntryDescriptorTest() {
    }

    @Test
    void shouldBeNonProcessedAsDefault() {
        UnsafeBuffer buffer = new UnsafeBuffer(new byte[128]);
        boolean processed = LogEntryDescriptor.shouldSkipProcessing((DirectBuffer)buffer, (int)0);
        Assertions.assertThat((boolean)processed).isFalse();
    }

    @Test
    void shouldMarkAsProcessed() {
        UnsafeBuffer buffer = new UnsafeBuffer(new byte[128]);
        LogEntryDescriptor.skipProcessing((MutableDirectBuffer)buffer, (int)0);
        Assertions.assertThat((boolean)LogEntryDescriptor.shouldSkipProcessing((DirectBuffer)buffer, (int)0)).isTrue();
    }

    @Test
    void shouldReadShortMetadataLength() {
        UnsafeBuffer buffer = new UnsafeBuffer(new byte[128]);
        LogEntryDescriptor.setVersion((MutableDirectBuffer)buffer, (int)0);
        LogEntryDescriptor.setMetadataLength((MutableDirectBuffer)buffer, (int)0, (int)34);
        Assertions.assertThat((int)LogEntryDescriptor.getMetadataLength((DirectBuffer)buffer, (int)0)).isEqualTo(34);
    }

    @Test
    void shouldReadLargeMetadataLength() {
        UnsafeBuffer buffer = new UnsafeBuffer(new byte[128]);
        LogEntryDescriptor.setVersion((MutableDirectBuffer)buffer, (int)0);
        LogEntryDescriptor.setMetadataLength((MutableDirectBuffer)buffer, (int)0, (int)32777);
        Assertions.assertThat((int)LogEntryDescriptor.getMetadataLength((DirectBuffer)buffer, (int)0)).isEqualTo(32777);
    }

    @Test
    void shouldReadMetadataLengthFromOldVersion() {
        byte[] byteArray = new byte[128];
        Arrays.fill(byteArray, (byte)8);
        UnsafeBuffer buffer = new UnsafeBuffer(byteArray);
        buffer.putShort(LogEntryDescriptor.versionOffset((int)0), (short)0, Protocol.ENDIANNESS);
        LogEntryDescriptor.setMetadataLength((MutableDirectBuffer)buffer, (int)0, (int)34);
        Assertions.assertThat((int)LogEntryDescriptor.getMetadataLength((DirectBuffer)buffer, (int)0)).isEqualTo(34);
    }

    @Test
    void shouldReadMetadataLengthFromOldVersionWhenVersionNotSet() {
        byte[] byteArray = new byte[128];
        Arrays.fill(byteArray, (byte)8);
        UnsafeBuffer buffer = new UnsafeBuffer(byteArray);
        buffer.putShort(LogEntryDescriptor.versionOffset((int)0), (short)123, Protocol.ENDIANNESS);
        LogEntryDescriptor.setMetadataLength((MutableDirectBuffer)buffer, (int)0, (int)34);
        Assertions.assertThat((int)LogEntryDescriptor.getMetadataLength((DirectBuffer)buffer, (int)0)).isEqualTo(34);
    }
}

