/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.serializer;

import io.camunda.zeebe.logstreams.impl.log.SequencedBatch;
import io.camunda.zeebe.logstreams.impl.serializer.DataFrameDescriptor;
import io.camunda.zeebe.logstreams.impl.serializer.LogAppendEntrySerializer;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.protocol.Protocol;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class SequencedBatchSerializer {
    public static ByteBuffer serializeBatch(SequencedBatch batch) {
        Objects.requireNonNull(batch, "must provide a batch to serialize");
        ByteBuffer buffer = ByteBuffer.allocate(batch.length()).order(Protocol.ENDIANNESS);
        UnsafeBuffer mutableBuffer = new UnsafeBuffer(buffer);
        SequencedBatchSerializer.serializeBatch((MutableDirectBuffer)mutableBuffer, 0, batch);
        return buffer;
    }

    public static void serializeBatch(MutableDirectBuffer buffer, int offset, SequencedBatch batch) {
        int currentOffset = offset;
        for (int i = 0; i < batch.entries().size(); ++i) {
            LogAppendEntry entry = batch.entries().get(i);
            int framedLength = LogAppendEntrySerializer.serialize(buffer, currentOffset, entry, batch.firstPosition() + (long)i, SequencedBatchSerializer.getSourcePosition(batch, i, entry), batch.timestamp());
            currentOffset += DataFrameDescriptor.alignedLength(framedLength);
        }
    }

    public static int calculateBatchLength(List<LogAppendEntry> entries) {
        return entries.stream().mapToInt(SequencedBatchSerializer::calculateEntryLength).sum();
    }

    private static int calculateEntryLength(LogAppendEntry entry) {
        return DataFrameDescriptor.alignedLength(LogAppendEntrySerializer.framedLength(entry));
    }

    private static long getSourcePosition(SequencedBatch batch, int i, LogAppendEntry entry) {
        long sourcePosition = entry.sourceIndex() >= 0 && entry.sourceIndex() < i ? batch.firstPosition() + (long)entry.sourceIndex() : batch.sourcePosition();
        return sourcePosition;
    }
}

