/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;

final class SequencerMetrics {
    private final DistributionSummary batchSize;
    private final DistributionSummary batchLengthBytes;

    SequencerMetrics(MeterRegistry meterRegistry) {
        this.batchSize = DistributionSummary.builder((String)SequencerMetricsDoc.BATCH_SIZE.getName()).description(SequencerMetricsDoc.BATCH_SIZE.getDescription()).serviceLevelObjectives(SequencerMetricsDoc.BATCH_SIZE.getDistributionSLOs()).register(meterRegistry);
        this.batchLengthBytes = DistributionSummary.builder((String)SequencerMetricsDoc.BATCH_LENGTH_BYTES.getName()).description(SequencerMetricsDoc.BATCH_LENGTH_BYTES.getDescription()).serviceLevelObjectives(SequencerMetricsDoc.BATCH_LENGTH_BYTES.getDistributionSLOs()).register(meterRegistry);
    }

    void observeBatchSize(int size) {
        this.batchSize.record((double)size);
    }

    void observeBatchLengthBytes(int lengthBytes) {
        int batchLengthKiloBytes = Math.floorDiv(lengthBytes, 1024);
        this.batchLengthBytes.record((double)batchLengthKiloBytes);
    }

    public static enum SequencerMetricsDoc implements ExtendedMeterDocumentation
    {
        BATCH_SIZE{
            private static final double[] BUCKETS = new double[]{1.0, 2.0, 3.0, 5.0, 10.0, 25.0, 50.0, 100.0, 500.0, 1000.0};

            public String getDescription() {
                return "Histogram over the number of entries in each batch that is appended";
            }

            public String getName() {
                return "zeebe.sequencer.batch.size";
            }

            public Meter.Type getType() {
                return Meter.Type.DISTRIBUTION_SUMMARY;
            }

            public double[] getDistributionSLOs() {
                return BUCKETS;
            }

            public KeyName[] getAdditionalKeyNames() {
                return MicrometerUtil.PartitionKeyNames.values();
            }
        }
        ,
        BATCH_LENGTH_BYTES{
            private static final double[] BUCKETS = new double[]{0.256, 0.512, 1.0, 4.0, 8.0, 32.0, 128.0, 512.0, 1024.0, 4096.0};

            public String getDescription() {
                return "Histogram over the size, in Kilobytes, of the sequenced batches";
            }

            public String getName() {
                return "zeebe.sequencer.batch.length.bytes";
            }

            public String getBaseUnit() {
                return "KiB";
            }

            public Meter.Type getType() {
                return Meter.Type.DISTRIBUTION_SUMMARY;
            }

            public double[] getDistributionSLOs() {
                return BUCKETS;
            }

            public KeyName[] getAdditionalKeyNames() {
                return MicrometerUtil.PartitionKeyNames.values();
            }
        };

    }
}

