/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.logstreams.impl.flowcontrol.FlowControl;
import io.camunda.zeebe.logstreams.impl.flowcontrol.InFlightEntry;
import io.camunda.zeebe.logstreams.impl.log.LogAppendEntryMetadata;
import io.camunda.zeebe.logstreams.impl.log.SequencedBatch;
import io.camunda.zeebe.logstreams.impl.log.SequencerMetrics;
import io.camunda.zeebe.logstreams.impl.serializer.SequencedBatchSerializer;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.logstreams.log.WriteContext;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.util.Either;
import java.io.Closeable;
import java.lang.runtime.SwitchBootstraps;
import java.time.InstantSource;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Sequencer
implements LogStreamWriter,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Sequencer.class);
    private final int maxFragmentSize;
    private volatile long position;
    private volatile boolean isClosed = false;
    private final ReentrantLock lock = new ReentrantLock();
    private final LogStorage logStorage;
    private final InstantSource clock;
    private final SequencerMetrics sequencerMetrics;
    private final FlowControl flowControl;

    Sequencer(LogStorage logStorage, long initialPosition, int maxFragmentSize, InstantSource clock, SequencerMetrics sequencerMetrics, FlowControl flowControl) {
        LOG.trace("Starting new sequencer at position {}", (Object)initialPosition);
        this.logStorage = logStorage;
        this.clock = Objects.requireNonNull(clock);
        this.position = initialPosition;
        this.maxFragmentSize = maxFragmentSize;
        this.sequencerMetrics = Objects.requireNonNull(sequencerMetrics, "must specify sequencer metrics");
        this.flowControl = flowControl;
    }

    @Override
    public boolean canWriteEvents(int eventCount, int batchSize) {
        int framedMessageLength = batchSize + eventCount * 20 + 8;
        return framedMessageLength <= this.maxFragmentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Either<LogStreamWriter.WriteFailure, Long> tryWrite(WriteContext context, List<LogAppendEntry> appendEntries, long sourcePosition) {
        int n;
        InFlightEntry inFlightEntry;
        if (this.isClosed) {
            LOG.warn("Rejecting write of {}, sequencer is closed", appendEntries);
            return Either.left((Object)((Object)LogStreamWriter.WriteFailure.CLOSED));
        }
        if (appendEntries.isEmpty()) {
            return Either.left((Object)((Object)LogStreamWriter.WriteFailure.INVALID_ARGUMENT));
        }
        for (LogAppendEntry logAppendEntry : appendEntries) {
            if (Sequencer.isEntryValid(logAppendEntry)) continue;
            LOG.warn("Reject write of invalid entry {}", (Object)logAppendEntry);
            return Either.left((Object)((Object)LogStreamWriter.WriteFailure.INVALID_ARGUMENT));
        }
        Either<FlowControl.Rejection, InFlightEntry> either = this.flowControl.tryAcquire(context, LogAppendEntryMetadata.copyMetadata(appendEntries));
        Objects.requireNonNull(either);
        Either<FlowControl.Rejection, InFlightEntry> either2 = either;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Either.Left.class, Either.Right.class}, either2, n2)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                FlowControl.Rejection right;
                Either.Left left = (Either.Left)either2;
                FlowControl.Rejection rejected = right = (FlowControl.Rejection)((Object)left.value());
                return switch (rejected) {
                    default -> throw new MatchException(null, null);
                    case FlowControl.Rejection.RequestLimitExhausted -> Either.left((Object)((Object)LogStreamWriter.WriteFailure.REQUEST_LIMIT_EXHAUSTED));
                    case FlowControl.Rejection.WriteRateLimitExhausted -> Either.left((Object)((Object)LogStreamWriter.WriteFailure.WRITE_LIMIT_EXHAUSTED));
                };
            }
            case 1: 
        }
        Either.Right right = (Either.Right)either2;
        try {
            InFlightEntry inFlightEntry2;
            InFlightEntry accepted;
            inFlightEntry = accepted = (inFlightEntry2 = (InFlightEntry)right.value());
            n = appendEntries.size();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        int batchLength = SequencedBatchSerializer.calculateBatchLength(appendEntries);
        this.lock.lock();
        try {
            long currentPosition = this.position;
            long highestPosition = currentPosition + (long)n - 1L;
            SequencedBatch sequencedBatch = new SequencedBatch(this.clock.millis(), currentPosition, sourcePosition, appendEntries, batchLength);
            this.flowControl.onAppend(inFlightEntry, highestPosition);
            this.logStorage.append(currentPosition, highestPosition, sequencedBatch, (LogStorage.AppendListener)this.flowControl);
            this.position = currentPosition + (long)n;
            Either either3 = Either.right((Object)highestPosition);
            return either3;
        }
        finally {
            this.lock.unlock();
            this.sequencerMetrics.observeBatchLengthBytes(batchLength);
            this.sequencerMetrics.observeBatchSize(n);
        }
    }

    @Override
    public void close() {
        LOG.info("Closing sequencer for writing");
        this.isClosed = true;
    }

    private static boolean isEntryValid(LogAppendEntry entry) {
        return entry.recordValue() != null && entry.recordMetadata() != null;
    }
}

