/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl;

import io.camunda.zeebe.logstreams.impl.LogStreamMetricsDoc;
import io.camunda.zeebe.logstreams.impl.flowcontrol.FlowControl;
import io.camunda.zeebe.logstreams.impl.log.LogAppendEntryMetadata;
import io.camunda.zeebe.logstreams.log.WriteContext;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.collection.Map3D;
import io.camunda.zeebe.util.collection.Table;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public final class LogStreamMetrics {
    private final AtomicLong inflightAppends = new AtomicLong();
    private final AtomicLong inflightRequests = new AtomicLong();
    private final AtomicLong requestLimit = new AtomicLong();
    private final AtomicLong lastCommitted = new AtomicLong();
    private final AtomicLong lastWritten = new AtomicLong();
    private final AtomicLong exportingRate = new AtomicLong();
    private final AtomicLong writeRateMaxLimit = new AtomicLong();
    private final AtomicLong writeRateLimit = new AtomicLong();
    private final AtomicLong partitionLoad = new AtomicLong();
    private final Map3D<RecordType, ValueType, Intent, Counter> recordAppended = Map3D.simple();
    private final Table<LogStreamMetricsDoc.FlowControlContext, LogStreamMetricsDoc.FlowControlOutcome, Counter> flowControlOutcome = Table.ofEnum(LogStreamMetricsDoc.FlowControlContext.class, LogStreamMetricsDoc.FlowControlOutcome.class, Counter[]::new);
    private final MeterRegistry registry;
    private final Counter deferredAppends;
    private final Counter triedAppends;
    private final Counter receivedRequests;
    private final Counter droppedRequests;
    private final Timer commitLatency;
    private final Timer appendLatency;

    public LogStreamMetrics(MeterRegistry registry) {
        this.registry = registry;
        this.deferredAppends = this.registerCounter(LogStreamMetricsDoc.TOTAL_DEFERRED_APPEND_COUNT);
        this.triedAppends = this.registerCounter(LogStreamMetricsDoc.TOTAL_APPEND_TRY_COUNT);
        this.receivedRequests = this.registerCounter(LogStreamMetricsDoc.TOTAL_RECEIVED_REQUESTS);
        this.droppedRequests = this.registerCounter(LogStreamMetricsDoc.TOTAL_DROPPED_REQUESTS);
        this.commitLatency = MicrometerUtil.buildTimer((ExtendedMeterDocumentation)LogStreamMetricsDoc.COMMIT_LATENCY).register(registry);
        this.appendLatency = MicrometerUtil.buildTimer((ExtendedMeterDocumentation)LogStreamMetricsDoc.WRITE_LATENCY).register(registry);
        this.registerGauge(LogStreamMetricsDoc.INFLIGHT_APPENDS, this.inflightAppends);
        this.registerGauge(LogStreamMetricsDoc.INFLIGHT_REQUESTS, this.inflightAppends);
        this.registerGauge(LogStreamMetricsDoc.REQUEST_LIMIT, this.requestLimit);
        this.registerGauge(LogStreamMetricsDoc.LAST_COMMITTED_POSITION, this.lastCommitted);
        this.registerGauge(LogStreamMetricsDoc.LAST_WRITTEN_POSITION, this.lastWritten);
        this.registerGauge(LogStreamMetricsDoc.EXPORTING_RATE, this.exportingRate);
        this.registerGauge(LogStreamMetricsDoc.WRITE_RATE_MAX_LIMIT, this.writeRateMaxLimit);
        Gauge.builder((String)LogStreamMetricsDoc.WRITE_RATE_LIMIT.getName(), (Object)this.writeRateLimit, LogStreamMetrics::longToDouble).description(LogStreamMetricsDoc.WRITE_RATE_LIMIT.getDescription()).register(registry);
        Gauge.builder((String)LogStreamMetricsDoc.PARTITION_LOAD.getName(), (Object)this.partitionLoad, LogStreamMetrics::longToDouble).description(LogStreamMetricsDoc.PARTITION_LOAD.getDescription()).register(registry);
    }

    public void increaseInflightAppends() {
        this.inflightAppends.incrementAndGet();
    }

    public void decreaseInflightAppends() {
        this.inflightAppends.decrementAndGet();
    }

    public void setInflightRequests(int count) {
        this.inflightRequests.set(count);
    }

    public void setRequestLimit(int limit) {
        this.requestLimit.set(limit);
    }

    public void increaseInflightRequests() {
        this.inflightRequests.incrementAndGet();
    }

    public void decreaseInflightRequests() {
        this.inflightRequests.decrementAndGet();
    }

    public CloseableSilently startWriteTimer() {
        return MicrometerUtil.timer((Timer)this.appendLatency, (Timer.Sample)Timer.start((MeterRegistry)this.registry));
    }

    public CloseableSilently startCommitTimer() {
        return MicrometerUtil.timer((Timer)this.commitLatency, (Timer.Sample)Timer.start((MeterRegistry)this.registry));
    }

    public void setLastWrittenPosition(long position) {
        this.lastWritten.set(position);
    }

    public void setLastCommittedPosition(long position) {
        this.lastCommitted.set(position);
    }

    public void recordAppendedEntry(int amount, RecordType recordType, ValueType valueType, Intent intent) {
        ((Counter)this.recordAppended.computeIfAbsent((Object)recordType, (Object)valueType, (Object)intent, this::registerRecordAppendedCounter)).increment((double)amount);
    }

    public void flowControlAccepted(WriteContext context, List<LogAppendEntryMetadata> batchMetadata) {
        this.triedAppends.increment();
        if (context instanceof WriteContext.UserCommand) {
            this.receivedRequests.increment();
        }
        ((Counter)this.flowControlOutcome.computeIfAbsent((Object)LogStreamMetrics.tagForContext(context), (Object)LogStreamMetricsDoc.FlowControlOutcome.ACCEPTED, this::registerFlowControlOutcomeCounter)).increment((double)batchMetadata.size());
    }

    public void flowControlRejected(WriteContext context, List<LogAppendEntryMetadata> batchMetadata, FlowControl.Rejection reason) {
        this.triedAppends.increment();
        this.deferredAppends.increment();
        if (context instanceof WriteContext.UserCommand) {
            this.receivedRequests.increment();
            this.droppedRequests.increment();
        }
        ((Counter)this.flowControlOutcome.computeIfAbsent((Object)LogStreamMetrics.tagForContext(context), (Object)LogStreamMetrics.tagForRejection(reason), this::registerFlowControlOutcomeCounter)).increment((double)batchMetadata.size());
    }

    public void setExportingRate(long value) {
        this.exportingRate.set(value);
    }

    public void setWriteRateMaxLimit(long value) {
        this.writeRateMaxLimit.set(value);
    }

    public void setPartitionLoad(double load) {
        this.partitionLoad.set(Double.doubleToLongBits(load));
    }

    public void setWriteRateLimit(double value) {
        this.writeRateLimit.set(Double.doubleToLongBits(value));
    }

    private Counter registerRecordAppendedCounter(RecordType recordType, ValueType valueType, Intent intent) {
        return Counter.builder((String)LogStreamMetricsDoc.RECORD_APPENDED.getName()).description(LogStreamMetricsDoc.RECORD_APPENDED.getDescription()).tag(LogStreamMetricsDoc.RecordAppendedKeyNames.RECORD_TYPE.asString(), recordType.name()).tag(LogStreamMetricsDoc.RecordAppendedKeyNames.VALUE_TYPE.asString(), valueType.name()).tag(LogStreamMetricsDoc.RecordAppendedKeyNames.INTENT.asString(), intent.name()).register(this.registry);
    }

    private Counter registerFlowControlOutcomeCounter(LogStreamMetricsDoc.FlowControlContext flowControlContext, LogStreamMetricsDoc.FlowControlOutcome flowControlOutcome) {
        return Counter.builder((String)LogStreamMetricsDoc.FLOW_CONTROL_OUTCOME.getName()).description(LogStreamMetricsDoc.FLOW_CONTROL_OUTCOME.getDescription()).tag(LogStreamMetricsDoc.FlowControlKeyNames.CONTEXT.asString(), flowControlContext.getValue()).tag(LogStreamMetricsDoc.FlowControlKeyNames.OUTCOME.asString(), flowControlOutcome.getValue()).register(this.registry);
    }

    private void registerGauge(ExtendedMeterDocumentation doc, AtomicLong gauge) {
        Gauge.builder((String)doc.getName(), (Object)gauge, AtomicLong::get).description(doc.getDescription()).register(this.registry);
    }

    private Counter registerCounter(ExtendedMeterDocumentation doc) {
        return Counter.builder((String)doc.getName()).description(doc.getDescription()).register(this.registry);
    }

    private static double longToDouble(AtomicLong value) {
        return Double.longBitsToDouble(value.get());
    }

    private static LogStreamMetricsDoc.FlowControlOutcome tagForRejection(FlowControl.Rejection reason) {
        return switch (reason) {
            default -> throw new MatchException(null, null);
            case FlowControl.Rejection.WriteRateLimitExhausted -> LogStreamMetricsDoc.FlowControlOutcome.WRITE_RATE_LIMIT_EXHAUSTED;
            case FlowControl.Rejection.RequestLimitExhausted -> LogStreamMetricsDoc.FlowControlOutcome.REQUEST_LIMIT_EXHAUSTED;
        };
    }

    private static LogStreamMetricsDoc.FlowControlContext tagForContext(WriteContext context) {
        WriteContext writeContext = context;
        Objects.requireNonNull(writeContext);
        WriteContext writeContext2 = writeContext;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WriteContext.UserCommand.class, WriteContext.ProcessingResult.class, WriteContext.InterPartition.class, WriteContext.Scheduled.class, WriteContext.Internal.class}, (Object)writeContext2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                WriteContext.UserCommand ignored = (WriteContext.UserCommand)writeContext2;
                yield LogStreamMetricsDoc.FlowControlContext.USER_COMMAND;
            }
            case 1 -> {
                WriteContext.ProcessingResult ignored = (WriteContext.ProcessingResult)writeContext2;
                yield LogStreamMetricsDoc.FlowControlContext.PROCESSING_RESULT;
            }
            case 2 -> {
                WriteContext.InterPartition ignored = (WriteContext.InterPartition)writeContext2;
                yield LogStreamMetricsDoc.FlowControlContext.INTER_PARTITION;
            }
            case 3 -> {
                WriteContext.Scheduled ignored = (WriteContext.Scheduled)writeContext2;
                yield LogStreamMetricsDoc.FlowControlContext.SCHEDULED;
            }
            case 4 -> {
                WriteContext.Internal ignored = (WriteContext.Internal)writeContext2;
                yield LogStreamMetricsDoc.FlowControlContext.INTERNAL;
            }
        };
    }
}

