/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.serializer;

import io.camunda.zeebe.logstreams.impl.log.LoggedEventImpl;
import io.camunda.zeebe.logstreams.impl.serializer.LogAppendEntrySerializer;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.logstreams.util.TestEntry;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.test.util.junit.RegressionTest;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class LogAppendEntrySerializerTest {
    private final MutableDirectBuffer writeBuffer = new ExpandableArrayBuffer();

    LogAppendEntrySerializerTest() {
    }

    @Test
    void shouldSerializeEntry() {
        LoggedEventImpl event = new LoggedEventImpl();
        LogAppendEntry entry = TestEntry.ofKey(1L);
        LogAppendEntrySerializer.serialize((MutableDirectBuffer)this.writeBuffer, (int)0, (LogAppendEntry)entry, (long)2L, (long)3L, (long)4L);
        event.wrap((DirectBuffer)this.writeBuffer, 0);
        TestEntry.TestEntryAssert.assertThatEntry(entry).matchesLoggedEvent((LoggedEvent)event);
        Assertions.assertThat((short)event.getVersion()).isEqualTo((short)1);
        Assertions.assertThat((long)event.getKey()).isEqualTo(1L);
        Assertions.assertThat((long)event.getPosition()).isEqualTo(2L);
        Assertions.assertThat((long)event.getSourceEventPosition()).isEqualTo(3L);
        Assertions.assertThat((long)event.getTimestamp()).isEqualTo(4L);
        Assertions.assertThat((boolean)event.shouldSkipProcessing()).isFalse();
    }

    @Test
    void shouldMarkEntryAsProcessed() {
        LoggedEventImpl event = new LoggedEventImpl();
        LogAppendEntry entry = TestEntry.ofKey(1L);
        LogAppendEntry processedEntry = LogAppendEntry.ofProcessed((LogAppendEntry)entry);
        LogAppendEntrySerializer.serialize((MutableDirectBuffer)this.writeBuffer, (int)0, (LogAppendEntry)processedEntry, (long)2L, (long)3L, (long)4L);
        event.wrap((DirectBuffer)this.writeBuffer, 0);
        TestEntry.TestEntryAssert.assertThatEntry(entry).matchesLoggedEvent((LoggedEvent)event);
        Assertions.assertThat((long)event.getKey()).isEqualTo(1L);
        Assertions.assertThat((long)event.getPosition()).isEqualTo(2L);
        Assertions.assertThat((long)event.getSourceEventPosition()).isEqualTo(3L);
        Assertions.assertThat((long)event.getTimestamp()).isEqualTo(4L);
        Assertions.assertThat((boolean)event.shouldSkipProcessing()).isTrue();
    }

    @Test
    void shouldFailWithEmptyMetadata() {
        LogAppendEntry entry = TestEntry.builder().withRecordMetadata(null).build();
        Assertions.assertThatCode(() -> LogAppendEntrySerializer.serialize((MutableDirectBuffer)this.writeBuffer, (int)0, (LogAppendEntry)entry, (long)2L, (long)3L, (long)4L)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void shouldFailWithAnEmptyValue() {
        LogAppendEntry entry = TestEntry.builder().withRecordValue(null).build();
        Assertions.assertThatCode(() -> LogAppendEntrySerializer.serialize((MutableDirectBuffer)this.writeBuffer, (int)0, (LogAppendEntry)entry, (long)2L, (long)3L, (long)4L)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void shouldFailWithANegativeTimestamp() {
        LogAppendEntry entry = TestEntry.ofDefaults();
        Assertions.assertThatCode(() -> LogAppendEntrySerializer.serialize((MutableDirectBuffer)this.writeBuffer, (int)0, (LogAppendEntry)entry, (long)2L, (long)3L, (long)-1L)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldFailWithANegativePosition() {
        LogAppendEntry entry = TestEntry.ofDefaults();
        Assertions.assertThatCode(() -> LogAppendEntrySerializer.serialize((MutableDirectBuffer)this.writeBuffer, (int)0, (LogAppendEntry)entry, (long)-1L, (long)3L, (long)4L)).isInstanceOf(IllegalArgumentException.class);
    }

    @RegressionTest(value="https://github.com/camunda/camunda/issues/15989")
    void shouldWriteLargeMetadata() {
        String rejection = "foo".repeat(65534);
        LogAppendEntry entry = TestEntry.builder().withRecordValue(new TestValue().setFoo("bar")).build();
        LoggedEventImpl event = new LoggedEventImpl();
        RecordMetadata metadata = new RecordMetadata();
        TestValue value = new TestValue();
        entry.recordMetadata().rejectionReason(rejection);
        int serializedLength = LogAppendEntrySerializer.serialize((MutableDirectBuffer)this.writeBuffer, (int)0, (LogAppendEntry)entry, (long)0L, (long)-1L, (long)System.currentTimeMillis());
        event.wrap((DirectBuffer)this.writeBuffer, 0);
        event.readMetadata((BufferReader)metadata);
        event.readValue((BufferReader)value);
        Assertions.assertThat((int)serializedLength).isGreaterThan(Short.MAX_VALUE);
        Assertions.assertThat((String)metadata.getRejectionReason()).isEqualTo(rejection);
        Assertions.assertThat((String)value.getFoo()).isEqualTo("bar");
    }

    private static final class TestValue
    extends UnifiedRecordValue {
        private final StringProperty foo = new StringProperty("foo");

        private TestValue() {
            super(1);
            this.declareProperty((BaseProperty)this.foo);
        }

        private String getFoo() {
            return BufferUtil.bufferAsString((DirectBuffer)this.foo.getValue());
        }

        private TestValue setFoo(String value) {
            this.foo.setValue(value);
            return this;
        }
    }
}

