/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.log;

import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogAppendEntryTest {
    @Test
    public void shouldWrapValues() {
        RecordMetadata recordMetadata = new RecordMetadata();
        UnifiedRecordValue unifiedRecordValue = new UnifiedRecordValue(0);
        LogAppendEntry logAppendEntry = LogAppendEntry.of((RecordMetadata)recordMetadata, (UnifiedRecordValue)unifiedRecordValue);
        Assertions.assertThat((Object)logAppendEntry.recordValue()).isEqualTo((Object)unifiedRecordValue);
        Assertions.assertThat((Object)logAppendEntry.recordMetadata()).isEqualTo((Object)recordMetadata);
    }

    @Test
    public void shouldNotBeProcessedPerDefault() {
        RecordMetadata recordMetadata = new RecordMetadata();
        UnifiedRecordValue unifiedRecordValue = new UnifiedRecordValue(0);
        LogAppendEntry logAppendEntry = LogAppendEntry.of((RecordMetadata)recordMetadata, (UnifiedRecordValue)unifiedRecordValue);
        Assertions.assertThat((boolean)logAppendEntry.isProcessed()).isFalse();
        Assertions.assertThat((Object)logAppendEntry.recordValue()).isEqualTo((Object)unifiedRecordValue);
        Assertions.assertThat((Object)logAppendEntry.recordMetadata()).isEqualTo((Object)recordMetadata);
    }

    @Test
    public void shouldMarkEntryAsProcessed() {
        RecordMetadata recordMetadata = new RecordMetadata();
        UnifiedRecordValue unifiedRecordValue = new UnifiedRecordValue(0);
        LogAppendEntry logAppendEntry = LogAppendEntry.of((RecordMetadata)recordMetadata, (UnifiedRecordValue)unifiedRecordValue);
        LogAppendEntry processedEntry = LogAppendEntry.ofProcessed((LogAppendEntry)logAppendEntry);
        Assertions.assertThat((boolean)processedEntry.isProcessed()).isTrue();
        Assertions.assertThat((Object)logAppendEntry.recordValue()).isEqualTo((Object)unifiedRecordValue);
        Assertions.assertThat((Object)logAppendEntry.recordMetadata()).isEqualTo((Object)recordMetadata);
    }
}

