/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.Limiter;
import io.camunda.zeebe.logstreams.impl.LogStreamMetrics;
import io.camunda.zeebe.logstreams.impl.flowcontrol.AppendLimiter;
import io.camunda.zeebe.logstreams.impl.flowcontrol.InFlightAppend;
import io.camunda.zeebe.logstreams.impl.flowcontrol.VegasConfig;
import io.camunda.zeebe.util.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlowControl {
    private static final Logger LOG = LoggerFactory.getLogger(FlowControl.class);
    private final AppendLimiter appendLimiter;
    private final LogStreamMetrics metrics;

    public FlowControl(LogStreamMetrics metrics) {
        this.metrics = metrics;
        this.appendLimiter = this.configureAppendLimiter();
    }

    public Either<Rejection, InFlightAppend> tryAcquire() {
        Limiter.Listener appendListener = this.appendLimiter.acquire(null).orElse(null);
        if (appendListener == null) {
            this.metrics.increaseDeferredAppends();
            LOG.trace("Skipping append due to backpressure");
            return Either.left((Object)new Rejection.AppendLimitExhausted());
        }
        return Either.right((Object)new InFlightAppend(appendListener, this.metrics));
    }

    private AppendLimiter configureAppendLimiter() {
        VegasConfig algorithmCfg = new VegasConfig();
        LOG.debug("Configured log appender back pressure as {}. Window limiting is disabled", (Object)algorithmCfg);
        return ((AppendLimiter.AppenderLimiterBuilder)AppendLimiter.builder().limit((Limit)algorithmCfg.get())).metrics(this.metrics).build();
    }

    public static sealed interface Rejection {

        public record AppendLimitExhausted() implements Rejection
        {
        }
    }
}

