/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.util;

import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.buffer.BufferReader;
import java.util.Objects;
import org.assertj.core.api.AbstractObjectAssert;

public record TestEntry(long key, int sourceIndex, UnifiedRecordValue recordValue, RecordMetadata recordMetadata) implements LogAppendEntry
{
    public static LogAppendEntry ofDefaults() {
        return new TestLogAppendEntryBuilder().build();
    }

    public static TestLogAppendEntryBuilder builder() {
        return new TestLogAppendEntryBuilder();
    }

    public static LogAppendEntry ofKey(long key) {
        return new TestLogAppendEntryBuilder().withKey(key).build();
    }

    public static class TestLogAppendEntryBuilder {
        private long key = -1L;
        private int sourceIndex = -1;
        private UnifiedRecordValue recordValue = new UnifiedRecordValue(10);
        private RecordMetadata recordMetadata = new RecordMetadata().intent(Intent.UNKNOWN);

        public TestLogAppendEntryBuilder withKey(long key) {
            this.key = key;
            return this;
        }

        public TestLogAppendEntryBuilder withSourceIndex(int sourceIndex) {
            this.sourceIndex = sourceIndex;
            return this;
        }

        public TestLogAppendEntryBuilder withRecordValue(UnifiedRecordValue recordValue) {
            this.recordValue = recordValue;
            return this;
        }

        public TestLogAppendEntryBuilder withRecordMetadata(RecordMetadata recordMetadata) {
            this.recordMetadata = recordMetadata;
            return this;
        }

        public LogAppendEntry build() {
            return new TestEntry(this.key, this.sourceIndex, this.recordValue, this.recordMetadata);
        }
    }

    public static final class TestEntryAssert
    extends AbstractObjectAssert<TestEntryAssert, LogAppendEntry> {
        private TestEntryAssert(LogAppendEntry testEntry) {
            super((Object)testEntry, TestEntryAssert.class);
        }

        public static TestEntryAssert assertThatEntry(LogAppendEntry entry) {
            return new TestEntryAssert(entry);
        }

        public TestEntryAssert matchesLoggedEvent(LoggedEvent loggedEvent) {
            if (((LogAppendEntry)this.actual).key() != -1L && ((LogAppendEntry)this.actual).key() != loggedEvent.getKey()) {
                throw this.failureWithActualExpected(((LogAppendEntry)this.actual).key(), loggedEvent.getKey(), "Key <%s> was set on LogAppendEntry but LoggedEvent has key <%s>", new Object[]{((LogAppendEntry)this.actual).key(), loggedEvent.getKey()});
            }
            RecordMetadata loggedMetadata = new RecordMetadata();
            UnifiedRecordValue loggedValue = new UnifiedRecordValue(10);
            loggedEvent.readValue((BufferReader)loggedValue);
            loggedEvent.readMetadata((BufferReader)loggedMetadata);
            if (!Objects.equals(((LogAppendEntry)this.actual).recordValue(), loggedValue)) {
                throw this.failureWithActualExpected(((LogAppendEntry)this.actual).recordValue(), loggedValue, "LoggedEvent has a different value than LogAppendEntry", new Object[0]);
            }
            if (!Objects.equals(((LogAppendEntry)this.actual).recordMetadata(), loggedMetadata)) {
                throw this.failureWithActualExpected(((LogAppendEntry)this.actual).recordMetadata(), loggedMetadata, "LoggedEvent has different metadata than LogAppendEntry", new Object[0]);
            }
            return this;
        }
    }
}

