/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.util;

import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.logstreams.util.SyncLogStream;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Objects;

public final class SyncLogStreamBuilder
implements LogStreamBuilder {
    private final LogStreamBuilder delegate;
    private ActorSchedulingService actorSchedulingService;

    SyncLogStreamBuilder() {
        this(LogStream.builder());
    }

    SyncLogStreamBuilder(LogStreamBuilder delegate) {
        this.delegate = delegate;
    }

    public SyncLogStreamBuilder withActorSchedulingService(ActorSchedulingService actorSchedulingService) {
        this.actorSchedulingService = actorSchedulingService;
        this.delegate.withActorSchedulingService(actorSchedulingService);
        return this;
    }

    public SyncLogStreamBuilder withMaxFragmentSize(int maxFragmentSize) {
        this.delegate.withMaxFragmentSize(maxFragmentSize);
        return this;
    }

    public SyncLogStreamBuilder withLogStorage(LogStorage logStorage) {
        this.delegate.withLogStorage(logStorage);
        return this;
    }

    public SyncLogStreamBuilder withPartitionId(int partitionId) {
        this.delegate.withPartitionId(partitionId);
        return this;
    }

    public LogStreamBuilder withNodeId(int nodeId) {
        this.delegate.withNodeId(nodeId);
        return this;
    }

    public SyncLogStreamBuilder withLogName(String logName) {
        this.delegate.withLogName(logName);
        return this;
    }

    public LogStreamBuilder withMeterRegistry(MeterRegistry meterRegistry) {
        this.delegate.withMeterRegistry(meterRegistry);
        return this;
    }

    public ActorFuture<LogStream> buildAsync() {
        return this.delegate.buildAsync();
    }

    public SyncLogStream build() {
        ActorSchedulingService scheduler = Objects.requireNonNull(this.actorSchedulingService, "must provide an actor scheduling service through SyncLogStreamBuilder#withActorSchedulingService");
        final CompletableActorFuture buildFuture = new CompletableActorFuture();
        scheduler.submitActor(new Actor(){

            protected void onActorStarting() {
                this.actor.runOnCompletionBlockingCurrentPhase(SyncLogStreamBuilder.this.buildAsync(), (logStream, t) -> {
                    if (t == null) {
                        buildFuture.complete((Object)new SyncLogStream((LogStream)logStream));
                    } else {
                        buildFuture.completeExceptionally(t);
                    }
                });
            }
        });
        return (SyncLogStream)buildFuture.join();
    }
}

